/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		osfilesource.h

	Contains:	simple file abstraction. This file abstraction is ONLY to be
				used for files intended for serving 
					
	$Log: OSFileSource.h,v $
	Revision 1.1  1999/06/02 18:14:50  serenyi
	Akamaizable version of OSFi
	
	Revision 1.1  1999/05/27 00:21:52  serenyi
	
	Revision 1.2  1999/02/19 23:06:12  ds
	Created
	
	
*/

#ifndef __OSFILE_H_
#define __OSFILE_H_

#include <stdio.h>

#include "QTSS.h"
#include "OSHeaders.h"


class OSFileSource
{
	public:
		OSFileSource() : fFile(-1), fLength(0), fPosition(0), fReadPos(0) {}
		OSFileSource(const char *inPath) : fFile(-1) { Set(inPath); }
		~OSFileSource() { Close(); }
		
		//Sets this object to reference this file
		void 			Set(const char *inPath);
		
		//Advise: this advises the OS that we are going to be reading soon from the
		//following position in the file
		void			Advise(UInt64 advisePos, UInt32 adviseAmt);

		QTSS_ErrorCode	Read(void* inBuffer, UInt32 inLength, UInt32* outRcvLen = NULL);
		QTSS_ErrorCode	Read(UInt64 inPosition, void* inBuffer, UInt32 inLength,
								UInt32* outRcvLen = NULL);
		
		QTSS_ErrorCode	Close();
		
		UInt64			GetLength() 				{ return fLength; }
		void			Seek(SInt64 newPosition) 	{ fPosition = newPosition; 	}
		bool IsValid() 								{ return fFile != -1; 		}
		
	protected:

		void ResetFD()	{ fFile=-1; }

	private:

		int		fFile;
		UInt64	fLength;
		UInt64	fPosition;
		UInt64	fReadPos;
};

#endif //__OSFILE_H_
