/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPWebStatsModule.cpp

	Contains:	Implements web stats module

	$Log: RTSPWebStatsModule.cpp,v $
	Revision 1.1  1999/02/26 05:14:57  cl
	Added HTTP stats (RTSPWebStatsModule)
	

	

*/

#ifndef __MW_
#include <unistd.h>		/* for getopt() et al */
#include <stdio.h>		/* for printf */
#include <stdlib.h>		/* for getloadavg & other useful stuff */
#if __MacOSX__
#include <mach/mach.h>	/* for mach cpu state struct and functions */
#endif
#endif

#include "RTSPWebStatsModule.h"
#include "RTPServerInterface.h"
#include "OS.h"
#include "StringParser.h"


char* RTSPWebStatsModule::sResponseHeader = "HTTP/1.0 200 OK\r\nServer: TimeShare/1.0\r\nConnection: Close\r\nContent-Type: text/html\r\n\r\n";

const char* kGetRequest = "GET /";
const char* kDirListRequest = "GET /dir";


//**************************************************
class CPUStats {
public:
	static void GetStats( double *dpLoad, long *lpTicks);
#if __MacOSX__
	static void GetMachineInfo(machine_info* ioMachineInfo) 
	{	if (!CPUStats::sInited)
			CPUStats::Init();
		*ioMachineInfo = sMachineInfo;
	}
#endif
	static void Init();
private:
	static int	_CPUCount ;
	static int	_CPUSlots [16] ;
#if __MacOSX__
	static long _laLastTicks [CPU_STATE_MAX] ;
	static struct machine_info sMachineInfo;
#endif
	static bool sInited;

};
bool CPUStats::sInited = false;
int	CPUStats::_CPUCount = 1;
int	CPUStats::_CPUSlots [16] = {-1};
#if __MacOSX__
long CPUStats::_laLastTicks[CPU_STATE_MAX];
struct machine_info CPUStats::sMachineInfo  = {};
#endif


//**************************************************


void RTSPWebStatsModule::FilterRequest(RTSPRequestInterface* request)
{
	UInt8 sParamStopMask[] =
	{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //0-9      //stop unless a '\t', ' ', or '&'
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //10-19  
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //20-29
	0, 0, 0, 0, 0, 0, 0, 0, 1, 0, //30-39   
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //40-49
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //50-59
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //60-69
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //70-79
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //80-89
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //90-99
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //100-109
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //110-119
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //120-129
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //130-139
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //140-149
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //150-159
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //160-169
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //170-179
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //180-189
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //190-199
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //200-209
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //210-219
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //220-229
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //230-239
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //240-249
	0, 0, 0, 0, 0, 1 			 //250-255
};

	//check to see if we should handle this request. Invokation is triggered
	//by a "GET /" request
	
	StringParser fullRequest(request->GetQTSSParameter(qtssFullRequestParam));
	StrPtrLen	strPtr;
	StrPtrLen	paramName;
	StrPtrLen	fieldsList;
	
	fullRequest.ConsumeWord(&strPtr);
	if ( strPtr.Equal(StrPtrLen("GET")) )	//it's a "Get" request
	{
		fullRequest.ConsumeWhitespace();
		if ( fullRequest.Expect('/') )
		{
			UInt32  refreshInterval = 0;
			bool  displayHelp = false;
			StrPtrLen* theWebStatsURL = RTSPServerInterface::GetRTSPPrefs()->GetWebStatsURL();
			
		
			fullRequest.ConsumeWord(&strPtr);
			if ( strPtr.Len != 0 && strPtr.Equal(*theWebStatsURL) )	//it's a "stats" request
			{
				if ( fullRequest.Expect('?') )
				{
					do {
						fullRequest.ConsumeWord(&paramName);
						
						if( paramName.Len != 0)
						{
							
							if ( paramName.Equal(StrPtrLen("refresh",strlen("refresh"))) )
							{
								if (fullRequest.Expect('='))
									refreshInterval  = fullRequest.ConsumeInteger(NULL);
							}
							else if ( paramName.Equal(StrPtrLen("help",strlen("help"))) )
							{
								displayHelp = true;
							}
							else if ( paramName.Equal(StrPtrLen("fields",strlen("fields"))) )
							{
								if (fullRequest.Expect('='))
									fullRequest.ConsumeUntil(&fieldsList, (UInt8*)sParamStopMask);
								
							}
						}
					} while ( paramName.Len != 0 && fullRequest.Expect('&') );
				}
				this->SendStats(request, refreshInterval, displayHelp, (fieldsList.Len != 0) ? &fieldsList : NULL);
			}
		}
	}
	


/*
	//skip past the "Get /"
	fullRequest.Ptr += ::strlen(kGetRequest);
	fullRequest.Len -= ::strlen(kGetRequest);


	if ( theWebStatsURL != NULL && 
		 theWebStatsURL->Ptr != NULL &&
		 theWebStatsURL->Len != 0 &&
		 fullRequest.Len >= ::strlen(theWebStatsURL->Ptr) &&
		 ::memcmp(fullRequest.Ptr, theWebStatsURL->Ptr, ::strlen(theWebStatsURL->Ptr)) == 0 )
	{
		fullRequest.Ptr += ::strlen(theWebStatsURL->Ptr);
		fullRequest.Len -= ::strlen(theWebStatsURL->Ptr);
		if ( fullRequest.Ptr[0] == '$' )
		{
			fullRequest.Ptr++;
			fullRequest.Len--;
			
			char saveChar = fullRequest.Ptr[fullRequest.Len];
			fullRequest.Ptr[fullRequest.Len] = '\0';	//skanky
			if (0 != sscanf(fullRequest->Ptr, "%d", &refreshInterval))
			fullRequest.Ptr[fullRequest.Len] = saveChar;
		}
		this->SendStats(request, refreshInterval);
	}
*/
	
	
/*	CURRENTLY UNIMPLEMNENTED
	else if ( (fullRequest.Len >= ::strlen(kDirListRequest)) &&
			  (::memcmp(fullRequest.Ptr, kDirListRequest, ::strlen(kDirListRequest)) == 0) )
	{
		this->SendDirList(request);
	}
*/
}

#if 0
void RTSPWebStatsModule::OBSOLETE_SendStats(RTSPRequestInterface* request, UInt32  refreshInterval, StrPtrLen* fieldList)
{	
	char buffer[1024];

	request->SetKeepAlive(false);//make sure to terminate this connection
	request->Write(sResponseHeader, ::strlen(sResponseHeader));
		


	if (fieldList == NULL)
	{
		if (refreshInterval > 0)
		{
			sprintf(buffer, "<META HTTP-EQUIV=Refresh CONTENT=%lu>\n", refreshInterval);
			request->Write(buffer, ::strlen(buffer));
		}
	
	
#if __MacOSX__
		sprintf(buffer, "<HTML><TITLE>QuickTime Streaming Server Stats</TITLE><BODY><BR>\n");
#else
		sprintf(buffer, "<HTML><TITLE>Streaming Server Stats</TITLE><BODY><BR>\n");
#endif
		request->Write(buffer, ::strlen(buffer));
		 
		sprintf(buffer, "<body text=\"#000000\" bgcolor=\"#C0C0C0\" link=\"#0000FF\" vlink=\"#551A8B\" alink=\"#0000FF\">\n");
		request->Write(buffer, ::strlen(buffer));
		
#if __MacOSX__
		sprintf(buffer, "<center><h1>QuickTime Streaming Server Statistics</h1></center>\n");
#else
		sprintf(buffer, "<center><h1>Streaming Server Statistics</h1></center>\n");
#endif
		request->Write(buffer, ::strlen(buffer));

		sprintf(buffer, "<b>DNS Name (default): </b> %s<BR>\n", RTSPServerInterface::GetDefaultDNSName()->Ptr);
		request->Write(buffer, ::strlen(buffer));
		
		time_t curTime = ::time(NULL); 
		sprintf(buffer, "<b>Current Time: </b> %s<BR><P><HR>", ctime(&curTime));
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Server Version: </b> %s<BR>\n", RTSPPrefs::GetServerVersion().Ptr);
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Server Build Date: </b> %s<BR>\n", RTSPPrefs::GetServerBuildDate().Ptr);
		request->Write(buffer, ::strlen(buffer));
	
		const char* states[]	= {	"Starting Up",
									"Running",
									"Refusing Connections",
									"Fatal Error",
									"Shutting Down"
								  };
		if (RTPServerInterface::GetServerState() == 1)
			sprintf(buffer, "<b>Status: </b> %s since %s<BR><P><HR>", states[RTPServerInterface::GetServerState()], ctime(&fStartupTime));
		else
			sprintf(buffer, "<b>Status: </b> %s<BR><P><HR>", states[RTPServerInterface::GetServerState()]);
		request->Write(buffer, ::strlen(buffer));
		
	//**********************************

#if __MacOSX__
		//misc machines stats
		double cpuLoad [3] ;
	    long cpuTicks[CPU_STATE_MAX] ;		  
		machine_info machineInfo = {};
	
		CPUStats::GetMachineInfo(&machineInfo);
		CPUStats::GetStats(cpuLoad, cpuTicks) ;
	
		sprintf(buffer, "<b>Kernel Info: </b> Mach kernel is v%d.%d, built for %d CPU[s]<BR>\n", 
						machineInfo.major_version, machineInfo.minor_version, machineInfo.max_cpus);
		request->Write(buffer, ::strlen(buffer));
	
		sprintf(buffer, "<b>CPU Stats: </b> %ld%% idle, %ld%% user, %ld%% system, load: %.2f, %.2f, %.2f<BR><P><HR>", 
						cpuTicks[CPU_STATE_IDLE], cpuTicks[CPU_STATE_USER], cpuTicks[CPU_STATE_SYSTEM], cpuLoad[0], cpuLoad[1], cpuLoad[2]);
		request->Write(buffer, ::strlen(buffer));
				
	/*	
		struct vm_statistics vmStats = {};
		if (vm_statistics (current_task (), &vmStats) != KERN_SUCCESS)
	        memset (&stats, '\0', sizeof (vmStats)) ;
	*/
#endif
	//**********************************
		sprintf(buffer, "<b>Current Connections: </b> %lu<BR>\n", RTPServerInterface::GetCurrentSessionCount());
		request->Write(buffer, ::strlen(buffer));
	
		sprintf(buffer, "<b>Current RTSP Connections: </b> %lu<BR>\n", RTSPServerInterface::GetCurrentSessionCount());
		request->Write(buffer, ::strlen(buffer));
	
		sprintf(buffer, "<b>Current Throughput: </b> %lu kbits<BR>\n", RTPServerInterface::GetCurrentBandwidthInBits()/1024);
		request->Write(buffer, ::strlen(buffer));
	
		sprintf(buffer, "<b>Current Packets Per Second: </b> %lu <BR>\n", RTPServerInterface::GetPacketsPerSecond());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Total Bytes Served: </b> %qu<BR>\n", RTPServerInterface::GetTotalBytes());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Total Connections: </b> %lu<BR><P><HR>", RTPServerInterface::GetTotalSessions());
		request->Write(buffer, ::strlen(buffer));
	
	//**************************************
		sprintf(buffer, "<b>Maximum Connections: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxConnections());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Maximum Throughput: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxKBitsBandwidth());
		request->Write(buffer, ::strlen(buffer));
		
		OSCharArrayDeleter theMovieFolderLoc(RTSPServerInterface::GetRTSPPrefs()->GetMovieFolderPath());
		sprintf(buffer, "<b>Movie Folder Path: </b> %s<BR>\n", theMovieFolderLoc.GetObject());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>RTSP IP Address: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetRTSPIPAddress());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Primary RTSP Port: </b> %u<BR>\n", RTSPServerInterface::GetFirstListener()->GetLocalPort());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>RTSP Timout: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetRTSPTimeoutInSecs());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>RTP Timout: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetRTPTimeoutInSecs());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Seconds To Buffer: </b> %lu<BR><P><HR>", RTSPServerInterface::GetRTSPPrefs()->GetSecondsToBuffer());
		request->Write(buffer, ::strlen(buffer));
		
		
		sprintf(buffer, "<b>Access Logging: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->IsTransferLogEnabled() ? "enabled" : "disabled");
		request->Write(buffer, ::strlen(buffer));
		
		OSCharArrayDeleter theAccessLogDir(RTSPServerInterface::GetRTSPPrefs()->GetTransferLogDir());
		sprintf(buffer, "<b>Access Log Directory: </b> %s<BR>\n", theAccessLogDir.GetObject());
		request->Write(buffer, ::strlen(buffer));
		
		OSCharArrayDeleter theAccessRollName(RTSPServerInterface::GetRTSPPrefs()->GetTransferLogName());
		sprintf(buffer, "<b>Access Log Name: </b> %s<BR>\n", theAccessRollName.GetObject());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Access Log Roll Size: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxTransferLogBytes());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Access Log Roll Interval (days): </b> %ld<BR><P><HR>", RTSPServerInterface::GetRTSPPrefs()->GetTransferRollIntervalInDays());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Error Logging: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->IsErrorLogEnabled() ? "enabled" : "disabled");
		request->Write(buffer, ::strlen(buffer));
		
		OSCharArrayDeleter theErrorLogDir(RTSPServerInterface::GetRTSPPrefs()->GetErrorLogDir());
		sprintf(buffer, "<b>Error Log Directory: </b> %s<BR>\n", theErrorLogDir.GetObject());
		request->Write(buffer, ::strlen(buffer));
		
		OSCharArrayDeleter theErrorName(RTSPServerInterface::GetRTSPPrefs()->GetErrorLogName());
		sprintf(buffer, "<b>Error Log Name: </b> %s<BR>\n", theErrorName.GetObject());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Error Log Roll Size: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxErrorLogBytes());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Error Log Roll Interval (days): </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetErrorRollIntervalInDays());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Error Log Verbosity: </b> %lu<BR><P><HR>", RTSPServerInterface::GetRTSPPrefs()->GetErrorLogVerbosity());
		request->Write(buffer, ::strlen(buffer));
		
	
		sprintf(buffer, "<b>Break On Assert: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->ShouldServerBreakOnAssert() ? "enabled" : "disabled");
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>AutoStart: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->ShouldServerBreakOnAssert() ? "enabled" : "disabled");
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Total Bytes Update Interval: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetTotalBytesUpdateTimeInSecs());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Reflector Delay Time: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetTotalBytesUpdateTimeInSecs());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>Reflector Bucket Size: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetReflectorBucketSize());
		request->Write(buffer, ::strlen(buffer));
		
		sprintf(buffer, "<b>History Update Interval: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetHistoryUpdateIntervaInSecs());
		request->Write(buffer, ::strlen(buffer));
	
		sprintf(buffer, "<b>Out of file descriptors: </b> %d<BR>\n", RTSPServerInterface::GetFirstListener()->IsOutOfDescriptors());
		request->Write(buffer, ::strlen(buffer));
	
		//we can get the number of socket pairs, so we have to multiply by 2 to get number of sockets
		sprintf(buffer, "<b>Number of UDP sockets: </b> %ld<BR>\n", RTPServerInterface::GetSocketPool()->GetSocketQueue()->GetLength() * 2);
		request->Write(buffer, ::strlen(buffer));
	}
	else
	{
		StringParser fieldNamesParser(fieldList);
		StrPtrLen fieldName;
	
		sprintf(buffer, "<body text=\"#000000\" bgcolor=\"#C0C0C0\" link=\"#0000FF\" vlink=\"#551A8B\" alink=\"#0000FF\">\n");
		request->Write(buffer, ::strlen(buffer));
		
		
		do
		{
			fieldNamesParser.ConsumeWord(&fieldName);
#if __MacOSX__
			if ( fieldName.Equal(StrPtrLen("idlecpu",strlen("idlecpu"))) )
			{
					//misc machines stats
					double cpuLoad [3] ;
				    long cpuTicks[CPU_STATE_MAX];		  
					CPUStats::GetStats(cpuLoad, cpuTicks) ;
				
					sprintf(buffer, "CPU Idle: %ld%%<BR>", cpuTicks[CPU_STATE_IDLE]);
					request->Write(buffer, ::strlen(buffer));
			} 
			else if ( fieldName.Equal(StrPtrLen("usercpu",strlen("usercpu"))) )
			{
					//misc machines stats
					double cpuLoad [3] ;
				    long cpuTicks[CPU_STATE_MAX];		  
					CPUStats::GetStats(cpuLoad, cpuTicks) ;
				
					sprintf(buffer, "CPU User: %ld%%<BR>", cpuTicks[CPU_STATE_USER]);
					request->Write(buffer, ::strlen(buffer));
			} 
			else if ( fieldName.Equal(StrPtrLen("systemcpu",strlen("systemcpu"))) )
			{
					//misc machines stats
					double cpuLoad [3] ;
				    long cpuTicks[CPU_STATE_MAX];		  
					CPUStats::GetStats(cpuLoad, cpuTicks) ;
				
					sprintf(buffer, "CPU User: %ld%%<BR>", cpuTicks[CPU_STATE_SYSTEM]);
					request->Write(buffer, ::strlen(buffer));
			} 
			else
#endif 
			if ( fieldName.Equal(StrPtrLen("serverdns",strlen("serverdns"))) )
			{
					sprintf(buffer, "DNS: %s<BR>\n", RTSPServerInterface::GetDefaultDNSName()->Ptr);
					request->Write(buffer, ::strlen(buffer));
			}  
			else if ( fieldName.Equal(StrPtrLen("starttime",strlen("starttime"))) )
			{		
				sprintf(buffer, "Start Time:%s<BR>", ctime(&fStartupTime));
				request->Write(buffer, ::strlen(buffer));
			} 
			else if ( fieldName.Equal(StrPtrLen("timeofday",strlen("timeofday"))) )
			{		
				time_t curTime = ::time(NULL); 
				sprintf(buffer, "Current Time:%s<BR>", ctime(&curTime));
				request->Write(buffer, ::strlen(buffer));
			} 
			else if ( fieldName.Equal(StrPtrLen("curconns",strlen("curconns"))) )
			{		
				sprintf(buffer, "Current Connections: %lu<BR>", RTPServerInterface::GetCurrentSessionCount());
				request->Write(buffer, ::strlen(buffer));
			} 
			else if ( fieldName.Equal(StrPtrLen("curthru",strlen("curthru"))) )
			{		
				sprintf(buffer, "Current Throughput: %lu<BR>", RTPServerInterface::GetCurrentBandwidthInBits()/1024);
				request->Write(buffer, ::strlen(buffer));
			}
			else if ( fieldName.Equal(StrPtrLen("currtsp",strlen("currtsp"))) )
			{		
				sprintf(buffer, "Current RTSP Conns: %lu<BR>", RTSPServerInterface::GetCurrentSessionCount());
				request->Write(buffer, ::strlen(buffer));
			}
			else if ( fieldName.Equal(StrPtrLen("packets",strlen("packets"))) )
			{		
				sprintf(buffer, "Packets/Second: %lu<BR>", RTPServerInterface::GetPacketsPerSecond());
				request->Write(buffer, ::strlen(buffer));
			}
			else if ( fieldName.Equal(StrPtrLen("totbytes",strlen("totbytes"))) )
			{		
				sprintf(buffer, "Total Bytes: %qu<BR>", RTPServerInterface::GetTotalBytes());
				request->Write(buffer, ::strlen(buffer));
			}
			else if ( fieldName.Equal(StrPtrLen("totconns",strlen("totconns"))) )
			{		
				sprintf(buffer, "Total Conns: %lu<BR>", RTPServerInterface::GetTotalSessions());
				request->Write(buffer, ::strlen(buffer));
			}
			
		} while (fieldNamesParser.Expect(','));

	}
	
	//send the response
	request->Write(sResponseEnd, ::strlen(sResponseEnd));
	request->Close();
}
#endif

void RTSPWebStatsModule::SendDirList(RTSPRequestInterface* /*request*/)
{
	
}

void RTSPWebStatsModule::SendStats(RTSPRequestInterface* request, UInt32  refreshInterval, bool displayHelp, StrPtrLen* fieldList)
{
	struct FieldIndex {
		char*	fieldName;
		int fieldIndex;
	};
	
	const FieldIndex kFieldIndexes[] = {
									{"title", 1},
									{"dnsname", 2},
									{"curtime", 3},
									{"linebreak", 4},
									{"serververs", 5},
									{"serverbornon", 6},
									{"serverstatus", 7},
									{"linebreak", 8},
									{"noop", 9},
									{"kernelinfo", 10},
									{"cpuload", 11},
									{"noop", 12},
									{"linebreak", 13},
									{"currtp", 14},
									{"currtsp", 15},
									{"curthru", 16},
									{"curpkts", 17},
									{"totbytes", 18},
									{"totconns", 19},
									{"linebreak", 20},
									{"connlimit", 21},
									{"thrulimit", 22},
									{"moviedir", 23},
									{"rtspip", 24},
									{"rtspport", 25},
									{"rtsptimeout", 26},
									{"rtptimeout", 27},
									{"secstobuffer", 28},
									{"linebreak", 29},
									{"accesslog", 30},
									{"accesslogdir",31},
									{"accesslogname", 32},
									{"accessrollsize", 33},
									{"accessrollinterval", 34},
									{"linebreak", 35},
									{"errorlog", 36},
									{"errorlogdir", 37},
									{"errorlogname", 38},
									{"errorrollsize", 39},
									{"errorrollinterval", 40},
									{"errorloglevel", 41},
									{"linebreak", 42},
									{"assertbreak", 43},
									{"autostart", 44},
									{"totbytesupdateinterval", 45},
									{"reflectordelay", 46},
									{"reflectorbucketsize", 47},
									{"historyinterval", 48},
									{"outoffiledesc", 49},
									{"numudpsockets", 50}
	};
	const int kMaxFieldNum = 50;

	
	char buffer[1024];

	request->SetKeepAlive(false);//make sure to terminate this connection
	request->Write(sResponseHeader, ::strlen(sResponseHeader));

	if (refreshInterval > 0)
	{
		sprintf(buffer, "<META HTTP-EQUIV=Refresh CONTENT=%lu>\n", refreshInterval);
		request->Write(buffer, ::strlen(buffer));
	}
		
	sprintf(buffer, "<body text=\"#000000\" bgcolor=\"#C0C0C0\" link=\"#0000FF\" vlink=\"#551A8B\" alink=\"#0000FF\">\n");
	request->Write(buffer, ::strlen(buffer));

	request->Write("<HTML><BODY>\n", ::strlen("<HTML><BODY>\n"));
	
	if (displayHelp)
	{
		request->Write("<P><b>QuickTime Streaming Server Statistics Help</b></P>\n", ::strlen("<P><b>QuickTime Streaming Server Statistics Help</b></P>\n"));
		request->Write("<P>Example:</P>\n", ::strlen("<P>Example:</P>\n"));
		request->Write("<BLOCKQUOTE><P>http://server/statsURL?help&amp;refresh=15&amp;fields=curtime,cpuload </P>\n", ::strlen("<BLOCKQUOTE><P>HTTP://server/statsURL?help&amp;refresh=15&amp;fields=curtime,cpuload </P>\n"));

		request->Write("\"?\" means that there are options being attached to the stats request.<BR>\n", ::strlen("\"?\" means that there are options being attached to the stats request.<BR>\n"));
		request->Write("\"&amp;\" separates multiple stats options<BR>\n<BR>\n", ::strlen("\"&amp;\" separates multiple stats options<BR>\n<BR>\n"));

		request->Write("<P>The three possible parameters to stats are:</P>\n", ::strlen("<P>The three possible parameters to stats are:</P>\n"));
		request->Write("<P>\"help\"  -- shows the help information you're reading right now.</P>\n", ::strlen("<P>\"help\"  -- shows the help information you're reading right now.</P>\n"));
		request->Write("<P>\"refresh=&#91;n&#93;\"  -- tells the browser to automatically update the page every &#91;n&#93; seconds.</P>\n", ::strlen("<P>\"refresh=&#91;n&#93;\"  -- tells the browser to automatically update the page every &#91;n&#93; seconds.</P>\n"));
		request->Write("<P>\"fields=&#91;fieldList&#93;\"  -- show only the fields specified in &#91;fieldList&#93;</P>\n", ::strlen("<P>\"fields=&#91;fieldList&#93;\"  -- show only the fields specified in &#91;fieldList&#93;</P>\n"));
		request->Write("<BLOCKQUOTE>The following fields are available for use with the \"fields\" option:</P><BLOCKQUOTE><DL>\n", ::strlen("<BLOCKQUOTE>The following \"fields\" are available for use with the fields option:</P><BLOCKQUOTE><DL>\n"));
		
	
		for (short i = 0; i < kMaxFieldNum; i++)
		{
				sprintf(buffer, "<DT><I>%s</I></DT>\n", kFieldIndexes[i].fieldName);
				request->Write(buffer, ::strlen(buffer));
		}
		
		request->Write("</DL></BLOCKQUOTE></BLOCKQUOTE></BLOCKQUOTE><BR><P><HR>", ::strlen("</DL></BLOCKQUOTE></BLOCKQUOTE></BLOCKQUOTE><BR><P><HR>"));

	}

	StringParser fieldNamesParser(fieldList);
	StrPtrLen fieldName;
	int fieldNum = 0;
	do
	{
	
			
		if (fieldList != NULL)
		{
			fieldNum = 0;
			
			fieldNamesParser.ConsumeWord(&fieldName);
			
			for (short i = 0; i < kMaxFieldNum; i++)
			{
				if ( fieldName.Equal(StrPtrLen(kFieldIndexes[i].fieldName, ::strlen(kFieldIndexes[i].fieldName))) )
				{
					fieldNum = kFieldIndexes[i].fieldIndex;
					break;
				}
			}
		}
		else
		{
			fieldNum++;
			if ( fieldNum > kMaxFieldNum )
				fieldNum = 0;
		}

		switch (fieldNum)
		{
			case 1:
			{
#if __MacOSX__
					//sprintf(buffer, "<TITLE>QuickTime Streaming Server Stats</TITLE><BR>\n");
					request->Write("<TITLE>QuickTime Streaming Server Stats</TITLE><BR>\n", ::strlen("<TITLE>QuickTime Streaming Server Stats</TITLE><BR>\n"));
#else
					//sprintf(buffer, "<TITLE>Streaming Server Stats</TITLE><BR>\n");
					request->Write("<TITLE>Streaming Server Stats</TITLE><BR>\n", ::strlen("<TITLE>Streaming Server Stats</TITLE><BR>\n"));
#endif
					
#if __MacOSX__
					//sprintf(buffer, "<center><h1>QuickTime Streaming Server Statistics</h1></center>\n");
					request->Write("<center><h1>QuickTime Streaming Server Statistics</h1></center>\n", ::strlen("<center><h1>QuickTime Streaming Server Statistics</h1></center>\n"));
#else
					//sprintf(buffer, "<center><h1>Streaming Server Statistics</h1></center>\n");
					request->Write("<center><h1>Streaming Server Statistics</h1></center>\n", ::strlen("<center><h1>Streaming Server Statistics</h1></center>\n"));
#endif
			}
			break;
		
			case 2:
			{
				sprintf(buffer, "<b>DNS Name (default): </b> %s<BR>\n", RTSPServerInterface::GetDefaultDNSName()->Ptr);
				request->Write(buffer, ::strlen(buffer));
			}
			break;
			
			case 3:
			{
				time_t curTime = ::time(NULL); 
				sprintf(buffer, "<b>Current Time: </b> %s<BR>\n", ctime(&curTime));
				request->Write(buffer, ::strlen(buffer));
			}
			break;
			
			case 4:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
	
			case 5:
			{
				sprintf(buffer, "<b>Server Version: </b> %s<BR>\n", RTSPPrefs::GetServerVersion().Ptr);
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			case 6:
			{
				
				sprintf(buffer, "<b>Server Build Date: </b> %s<BR>\n", RTSPPrefs::GetServerBuildDate().Ptr);
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			case 7:
			{
			
				const char* states[]	= {	"Starting Up",
											"Running",
											"Refusing Connections",
											"Fatal Error",
											"Shutting Down"
										  };
				if (RTPServerInterface::GetServerState() == 1)
					sprintf(buffer, "<b>Status: </b> %s since %s<BR>", states[RTPServerInterface::GetServerState()], ctime(&fStartupTime));
				else
					sprintf(buffer, "<b>Status: </b> %s<BR>", states[RTPServerInterface::GetServerState()]);
				request->Write(buffer, ::strlen(buffer));
			}
			break;
			
			case 8:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
	
			case 9:
			{
				
				//NOOP
			}
			break;
			
		//**********************************
		//misc machines stats
			case 10:
			{
#if __MacOSX__
				machine_info machineInfo = {};


				CPUStats::GetMachineInfo(&machineInfo);
			
//				sprintf(buffer, "<b>Kernel Info: </b> Mach kernel is v%d.%d, built for %d CPU[s]<BR>\n", 
//								machineInfo.major_version, machineInfo.minor_version, machineInfo.max_cpus);
				sprintf(buffer, "<b>Kernel Info: </b> Mach kernel built for %d CPU[s]<BR>\n", machineInfo.max_cpus);
				request->Write(buffer, ::strlen(buffer));
#else
				request->Write("<b>Kernel info not available</b><BR>",::strlen("<b>Kernel info not available</b><BR>"));
#endif
			}
			break;
	
			case 11:
			{
#if __MacOSX__
				double cpuLoad [3] ;
			    long cpuTicks[CPU_STATE_MAX] ;
				
				CPUStats::GetStats(cpuLoad, cpuTicks) ;
				sprintf(buffer, "<b>CPU Stats: </b> %ld%% idle, %ld%% user, %ld%% system, load: %.2f, %.2f, %.2f<BR>", 
								cpuTicks[CPU_STATE_IDLE], cpuTicks[CPU_STATE_USER], cpuTicks[CPU_STATE_SYSTEM], cpuLoad[0], cpuLoad[1], cpuLoad[2]);
				request->Write(buffer, ::strlen(buffer));
#else
				request->Write("<b>CPU stats not available</b><BR>",::strlen("<b>CPU stats not available</b><BR>"));
#endif
			}
			break;
	
			case 12:
			{		
			/*	
				struct vm_statistics vmStats = {};
				if (vm_statistics (current_task (), &vmStats) != KERN_SUCCESS)
			        memset (&stats, '\0', sizeof (vmStats)) ;
			*/
			}
			break;
			
			case 13:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
				
			//**********************************



	
			case 14:
			{
				sprintf(buffer, "<b>Current Connections: </b> %lu<BR>\n", RTPServerInterface::GetCurrentSessionCount());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 15:
			{
			
				sprintf(buffer, "<b>Current RTSP Connections: </b> %lu<BR>\n", RTSPServerInterface::GetCurrentSessionCount());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 16:
			{
			
				sprintf(buffer, "<b>Current Throughput: </b> %lu kbits<BR>\n", RTPServerInterface::GetCurrentBandwidthInBits()/1024);
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 17:
			{
			
				sprintf(buffer, "<b>Current Packets Per Second: </b> %lu <BR>\n", RTPServerInterface::GetPacketsPerSecond());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 18:
			{
				
				sprintf(buffer, "<b>Total Bytes Served: </b> %qu<BR>\n", RTPServerInterface::GetTotalBytes());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 19:
			{
				
				sprintf(buffer, "<b>Total Connections: </b> %lu<BR>", RTPServerInterface::GetTotalSessions());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
			
			case 20:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
	
			//**************************************
			case 21:
			{
				sprintf(buffer, "<b>Maximum Connections: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxConnections());
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			case 22:
			{
				sprintf(buffer, "<b>Maximum Throughput: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxKBitsBandwidth());
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			case 23:
			{
				OSCharArrayDeleter theMovieFolderLoc(RTSPServerInterface::GetRTSPPrefs()->GetMovieFolderPath());
				sprintf(buffer, "<b>Movie Folder Path: </b> %s<BR>\n", theMovieFolderLoc.GetObject());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 24:
			{
				sprintf(buffer, "<b>RTSP IP Address: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetRTSPIPAddress());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 25:
			{
				sprintf(buffer, "<b>Primary RTSP Port: </b> %u<BR>\n", RTSPServerInterface::GetFirstListener()->GetLocalPort());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 26:
			{
				sprintf(buffer, "<b>RTSP Timout: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetRTSPTimeoutInSecs());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 27:
			{
				sprintf(buffer, "<b>RTP Timout: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetRTPTimeoutInSecs());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 28:
			{
				sprintf(buffer, "<b>Seconds To Buffer: </b> %lu<BR>", RTSPServerInterface::GetRTSPPrefs()->GetSecondsToBuffer());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
			
			case 29:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
	
			case 30:
			{
				
				sprintf(buffer, "<b>Access Logging: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->IsTransferLogEnabled() ? "enabled" : "disabled");
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 31:
			{
				OSCharArrayDeleter theAccessLogDir(RTSPServerInterface::GetRTSPPrefs()->GetTransferLogDir());
				sprintf(buffer, "<b>Access Log Directory: </b> %s<BR>\n", theAccessLogDir.GetObject());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 32:
			{
				OSCharArrayDeleter theAccessLogName(RTSPServerInterface::GetRTSPPrefs()->GetTransferLogName());
				sprintf(buffer, "<b>Access Log Name: </b> %s<BR>\n", theAccessLogName.GetObject());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 33:
			{
				sprintf(buffer, "<b>Access Log Roll Size: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxTransferLogBytes());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 34:
			{
				sprintf(buffer, "<b>Access Log Roll Interval (days): </b> %ld<BR>", RTSPServerInterface::GetRTSPPrefs()->GetTransferRollIntervalInDays());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
			
			case 35:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
	
			case 36:
			{
				sprintf(buffer, "<b>Error Logging: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->IsErrorLogEnabled() ? "enabled" : "disabled");
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 37:
			{
				OSCharArrayDeleter theErrorLogDir(RTSPServerInterface::GetRTSPPrefs()->GetErrorLogDir());
				sprintf(buffer, "<b>Error Log Directory: </b> %s<BR>\n", theErrorLogDir.GetObject());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 38:
			{
				OSCharArrayDeleter theErrorName(RTSPServerInterface::GetRTSPPrefs()->GetErrorLogName());
				sprintf(buffer, "<b>Error Log Name: </b> %s<BR>\n", theErrorName.GetObject());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 39:
			{
				sprintf(buffer, "<b>Error Log Roll Size: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetMaxErrorLogBytes());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 40:
			{
				sprintf(buffer, "<b>Error Log Roll Interval (days): </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetErrorRollIntervalInDays());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 41:
			{
				sprintf(buffer, "<b>Error Log Verbosity: </b> %lu<BR>", RTSPServerInterface::GetRTSPPrefs()->GetErrorLogVerbosity());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
			
			case 42:
			{
				request->Write("<P><HR>", ::strlen("<P><HR>"));
			}
			break;
	
			case 43:
			{
				sprintf(buffer, "<b>Break On Assert: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->ShouldServerBreakOnAssert() ? "enabled" : "disabled");
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 44:
			{
				sprintf(buffer, "<b>AutoStart: </b> %s<BR>\n", RTSPServerInterface::GetRTSPPrefs()->ShouldServerBreakOnAssert() ? "enabled" : "disabled");
				request->Write(buffer, ::strlen(buffer));

			}
			break;
	
			case 45:
			{
				sprintf(buffer, "<b>Total Bytes Update Interval: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetTotalBytesUpdateTimeInSecs());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 46:
			{
				sprintf(buffer, "<b>Reflector Delay Time: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetTotalBytesUpdateTimeInSecs());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 47:
			{
				sprintf(buffer, "<b>Reflector Bucket Size: </b> %lu<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetReflectorBucketSize());
				request->Write(buffer, ::strlen(buffer));



			}
			break;
	
			case 48:
			{
				sprintf(buffer, "<b>History Update Interval: </b> %ld<BR>\n", RTSPServerInterface::GetRTSPPrefs()->GetHistoryUpdateIntervaInSecs());
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			case 49:
			{
				sprintf(buffer, "<b>Out of file descriptors: </b> %d<BR>\n", RTSPServerInterface::GetFirstListener()->IsOutOfDescriptors());
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			case 50:
			{
			
				//we can get the number of socket pairs, so we have to multiply by 2 to get number of sockets
				sprintf(buffer, "<b>Number of UDP sockets: </b> %ld<BR>\n", RTPServerInterface::GetSocketPool()->GetSocketQueue()->GetLength() * 2);
				request->Write(buffer, ::strlen(buffer));
			}
			break;
	
			default:		
				break;
	
				
		} //switch fieldNum
			
			
		if (fieldList != NULL && !fieldNamesParser.Expect(','))
			fieldNum = 0;
			
	} while (fieldNum != 0);
	
	
	request->Write("</BODY></HTML>\n", ::strlen("</BODY></HTML>\n"));
	
	//send the response
	request->Close();


}






void CPUStats::Init()
{
#if __MacOSX__
    if (xxx_host_info (current_task (), &sMachineInfo) == KERN_SUCCESS) {
        register int		i, j = 0 ;
        struct machine_slot	slot ;

        _CPUCount = 0 ;
        for (i = sMachineInfo.max_cpus ; i-- ; )
            if ((xxx_slot_info (current_task (), i, &slot)
                 == KERN_SUCCESS) && (slot.is_cpu == 1)) {
                _CPUSlots[j++] = i ;
                _CPUCount++ ;
            }
        _CPUSlots[j] = -1 ;
		
	}
#endif
	
	CPUStats::sInited = true;
}

//courtesy of CJ
void CPUStats::GetStats ( double *dpLoad, long *lpTicks)
{
#if __MacOSX__
    register int	i ;
    register long	lTicks ;
    long			laSave [CPU_STATE_MAX];

	if (!CPUStats::sInited)
		CPUStats::Init();

    // Get the curent load average.
    if (-1 == getloadavg (dpLoad, 3))
    	dpLoad[0] = dpLoad[1] = dpLoad[2] = 0.0 ;

    // Return if mach says it doesn't have any CPUs.
    if (_CPUSlots[0] == -1) {
        lpTicks[0] = lpTicks[1] = lpTicks[2] = 0 ;
        return ;
    }

    // Accumulate all CPU ticks into one entry.
    laSave[0] = laSave[1] = laSave[2] = 0 ;
    for (i = _CPUCount ; i-- ; ) {
        struct machine_slot	slot ;

        // Get the percentages of CPU usage for each CPU.
        if ((xxx_slot_info (current_task (), _CPUSlots[i], &slot)
             == KERN_SUCCESS) && (slot.is_cpu == 1)) {
            laSave[CPU_STATE_USER] += slot.cpu_ticks[CPU_STATE_USER] ;
            laSave[CPU_STATE_SYSTEM] += slot.cpu_ticks[CPU_STATE_SYSTEM] ;
            laSave[CPU_STATE_IDLE] += slot.cpu_ticks[CPU_STATE_IDLE] ;
        }
    }

    // Get the difference between samples.
    for (lTicks = 0, i = CPU_STATE_MAX ; i-- ; ) {
        lpTicks[i] = laSave[i] - _laLastTicks[i] ;
        _laLastTicks[i] = laSave[i] ;
        lTicks += lpTicks[i] ;
        lpTicks[i] *= 100 ;
    }

    // Scale it to a percentage.
    if (lTicks) {
        lpTicks[CPU_STATE_USER] /= lTicks ;
        lpTicks[CPU_STATE_SYSTEM] /= lTicks ;
        lpTicks[CPU_STATE_IDLE] /= lTicks ;
    }
#endif
}
