/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		StreamDictionary.h

	Contains:	
					
	$Log: StreamDictionary.h,v $
	Revision 1.3  1999/06/03 01:37:49  lecroy
	added new 'pl' QTSS app packet selctor support, made sure PlayList worked on Linux
	
	Revision 1.2  1999/06/01 20:41:25  serenyi
	made linuxable
	
	Revision 1.1  1999/05/14 07:44:14  serenyi
	Created.
	

	Created: Tue, Mar 2, 1999 @ 4:23 PM
*/


#ifndef __STREAM_DICTIONARY_H__
#define __STREAM_DICTIONARY_H__

#include "Dictionary.h"


class StreamDictionary : public Dictionary
{
public:
	
	static void Initialize();
	
	StreamDictionary();
	virtual ~StreamDictionary();
	void SetStandardValue(UInt32 inStdValueIndex, const void* inValueBuffer, UInt32 inBufferLen);
	void* GetStandardValue(UInt32 inStdValueIndex, void* ioValueBuffer, UInt32 inBufferLen, UInt32* ioValueLen);
	UInt32 GetStandardUInt32Value(UInt32 inStdValueIndex, bool* ioWasFound = NULL);
	UInt16 GetStandardUInt16Value(UInt32 inStdValueIndex, bool* ioWasFound );

	//The dict ID manager for this dictionary type
	static DictValueIDManager sStreamDictValueIDManager;
	
	//"Standard" dictionary "indexes"
	enum {
		kFractionLostPackets = 0,
		kTotalLostPackets = 1,
		kHighestSeqNumberReceived = 2,
		kJitter = 3,
		kLastSenderReportTime = 4,
		kLastSenderReportDelay = 5,
		kReceiverBitRate = 6,
		kAvgLateMilliseconds = 7,
		kPercentPacketsLost = 8,
		kAverageBufferDelayMilliseconds = 9,
		kIsGettingBetter = 10,
		kIsGettingWorse = 11,
		kNumEyes = 12,
		kNumEyesActive = 13,
		kNumEyesPaused = 14,
		kTotalPacketsReceived = 15,
		kTotalPacketsDropped = 16,
		kClientBufferFill = 17,
		kFrameRate = 18,
		kExpectedFrameRate = 19,
		kAudioDryCount = 20,
		kTotalPacketsLost = 21,
		
		//count of the above items
		kStdSignatureCount = 22
	};
	
	static const FourCharCode kFractionLostPacketsSig = 'frac';
	static const FourCharCode kTotalLostPacketsSig = 'lost';
	static const FourCharCode kHighestSeqNumberReceivedSig = 'seq#';
	static const FourCharCode kJitterSig = 'jitr';
	static const FourCharCode kLastSenderReportTimeSig = 'rptm';
	static const FourCharCode kLastSenderReportDelaySig = 'rpdl';
	static const FourCharCode kReceiverBitRateSig = 'rrcv';
	static const FourCharCode kAvgLateMillisecondsSig = 'late';
	static const FourCharCode kPercentPacketsLostSig = 'loss';
	static const FourCharCode kAverageBufferDelayMillisecondsSig = 'bdly';
	static const FourCharCode kIsGettingBetterSig = ':|:(';
	static const FourCharCode kIsGettingWorseSig = ':|:)';
	static const FourCharCode kNumEyesSig = 'eyes';
	static const FourCharCode kNumEyesActiveSig = 'eyea';
	static const FourCharCode kNumEyesPausedSig = 'eyep';
	static const FourCharCode kTotalPacketsReceivedSig = 'prcv';
	static const FourCharCode kTotalPacketsDroppedSig = 'pdrp';
	static const FourCharCode kTotalPacketsLostSig = 'plos';
	static const FourCharCode kClientBufferFillSig = 'bufl';
	static const FourCharCode kFrameRateSig = 'frat';
	static const FourCharCode kExpectedFrameRateSig = 'xrat';
	static const FourCharCode kAudioDryCountSig = 'dry#';
		
	
protected:
	struct SigAndID {
		FourCharCode	valueSignature;
		UInt32			valueID;
	};
	
	static SigAndID sSigAndValueMap[kStdSignatureCount];
};

#endif
