/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFileInputStream;

public class ZipFile
implements ZipConstants {
    RandomAccessFile raf;
    private String name;
    private Hashtable entries;
    long cenpos;
    private long endpos;
    long pos;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private static final int INBUFSIZ = 64;

    public ZipFile(String string) throws IOException {
        this.raf = new RandomAccessFile(string, "r");
        this.name = string;
        this.readCEN();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(this, zipEntry);
        switch (zipEntry.method) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new InflaterInputStream(zipFileInputStream, new Inflater(true));
            }
        }
        throw new ZipException("invalid compression method");
    }

    public String getName() {
        return this.name;
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    synchronized int read(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (l != this.pos) {
            this.raf.seek(l);
        }
        if ((n3 = this.raf.read(byArray, n, n2)) > 0) {
            this.pos = l + (long)n3;
        }
        return n3;
    }

    synchronized int read(long l) throws IOException {
        int n;
        if (l != this.pos) {
            this.raf.seek(l);
        }
        if ((n = this.raf.read()) > 0) {
            this.pos = l + 1L;
        }
        return n;
    }

    private void readCEN() throws IOException {
        this.findEND();
        byte[] byArray = new byte[22];
        this.raf.readFully(byArray);
        if (ZipFile.get32(byArray, 0) != 101010256L) {
            throw new ZipException("invalid END header signature");
        }
        this.cenpos = ZipFile.get32(byArray, 16);
        int n = (int)ZipFile.get32(byArray, 12);
        if (this.cenpos + (long)n != this.endpos) {
            throw new ZipException("invalid END header format");
        }
        int n2 = ZipFile.get16(byArray, 10);
        if (n2 * 46 > n) {
            throw new ZipException("invalid END header format");
        }
        if (ZipFile.get16(byArray, 8) != n2) {
            throw new ZipException("cannot have more than one drive");
        }
        this.raf.seek(this.cenpos);
        byte[] byArray2 = new byte[n];
        this.raf.readFully(byArray2);
        this.entries = new Hashtable(n2);
        int n3 = 0;
        while (n3 < n) {
            if (ZipFile.get32(byArray2, n3) != 33639248L) {
                throw new ZipException("invalid CEN header signature");
            }
            ZipEntry zipEntry = new ZipEntry();
            zipEntry.version = ZipFile.get16(byArray2, n3 + 6);
            zipEntry.flag = ZipFile.get16(byArray2, n3 + 8);
            zipEntry.method = ZipFile.get16(byArray2, n3 + 10);
            zipEntry.time = ZipFile.get32(byArray2, n3 + 12);
            zipEntry.crc = ZipFile.get32(byArray2, n3 + 16);
            zipEntry.size = ZipFile.get32(byArray2, n3 + 24);
            zipEntry.csize = ZipFile.get32(byArray2, n3 + 20);
            zipEntry.offset = ZipFile.get32(byArray2, n3 + 42);
            if (zipEntry.offset + zipEntry.csize > this.cenpos) {
                throw new ZipException("invalid CEN entry size");
            }
            int n4 = n3;
            int n5 = ZipFile.get16(byArray2, n4 + 28);
            if (n5 == 0 || (n3 += 46) + n5 > n) {
                throw new ZipException("invalid CEN entry name");
            }
            zipEntry.name = new String(byArray2, 0, n3, n5);
            n3 += n5;
            n5 = ZipFile.get16(byArray2, n4 + 30);
            if (n5 > 0) {
                if (n3 + n5 > n) {
                    throw new ZipException("invalid CEN entry extra data");
                }
                zipEntry.extra = new byte[n5];
                System.arraycopy(byArray2, n3, zipEntry.extra, 0, n5);
                n3 += n5;
            }
            if ((n5 = ZipFile.get16(byArray2, n4 + 32)) > 0) {
                if (n3 + n5 > n) {
                    throw new ZipException("invalid CEN entry comment");
                }
                zipEntry.comment = new String(byArray2, 0, n3, n5);
                n3 += n5;
            }
            this.entries.put(zipEntry.name, zipEntry);
        }
        if (this.entries.size() != n2) {
            throw new ZipException("invalid CEN header format");
        }
    }

    private void findEND() throws IOException {
        long l = this.raf.length();
        this.raf.seek(l);
        long l2 = Math.max(0L, l - 65535L);
        byte[] byArray = new byte[68];
        this.pos = l;
        while (this.pos > l2) {
            int n = Math.min((int)(this.pos - l2), 64);
            this.pos -= (long)n;
            this.raf.seek(this.pos);
            this.raf.readFully(byArray, 0, n);
            while (--n > 0) {
                if (ZipFile.get32(byArray, n) != 101010256L) continue;
                this.endpos = this.pos + (long)n;
                if (l - this.endpos < 22L) continue;
                this.raf.seek(this.endpos);
                byte[] byArray2 = new byte[22];
                this.raf.readFully(byArray2);
                int n2 = ZipFile.get16(byArray2, 20);
                if (this.endpos + 22L + (long)n2 != l) continue;
                this.raf.seek(this.endpos);
                this.pos = this.endpos;
                return;
            }
        }
        throw new ZipException("not a ZIP file (END header not found)");
    }

    static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static final long get32(byte[] byArray, int n) {
        return (long)ZipFile.get16(byArray, n) | (long)ZipFile.get16(byArray, n + 2) << 16;
    }
}

