/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** indxMap.c
**
** maps from one table -> another
** maps anything < 0 to itself
** indexing is from 0 to indx->entries - 1
*/

# include "lclintMacros.nf"
# include "basic.h"

/*@only@*/ indxMap
indxMap_create ()
{
  int i;
  indxMap indx = (indxMap) dmalloc (sizeof (*indx));
  
  indx->entries = INDXMAP_BASESIZE;
  indx->map = (int *) dmalloc (INDXMAP_BASESIZE * sizeof (*indx->map));

  for (i = 0; i < indx->entries; i++) 
    {
      indx->map[i] = i;
    }

  return (indx);
}

void
indxMap_free (/*@only@*/ indxMap map)
{
  sfree (map->map);
  sfree (map);
}

static void
indxMap_expand (indxMap map, int size)
{
  int i;
  int oldentries = map->entries;
  int *oldmap = map->map;

  map->map = (int *) dmalloc (size * sizeof (*map->map));
  map->entries = size;
  
  for (i = 0; i < oldentries; i++)
    {
      map->map[i] = oldmap[i];
    }

  for (i = oldentries; i < map->entries; i++)
    {
      map->map[i] = i;
    }

  sfree (oldmap);
}

void
indxMap_addpair (indxMap map, int from, int to)
{
  if (from >= map->entries)
    indxMap_expand (map, from + 1);

  map->map[from] = to;
}

int
indxMap_map (indxMap map, int i)
{
  if (i < 0 || i >= map->entries)
    {
      llcontbug (message ("indxMap_map: out of range: %d", i));
      return (i);
    }
  else
    {
      return map->map[i];
    }
}

int
indxMap_mapSafe (indxMap map, int i)
{
  if (i < 0 || i >= map->entries)
    {
      return (i);
    }
  else
    {
      return map->map[i];
    }
}

/*@only@*/ cstring
indxMap_unparse (indxMap map)
{
  cstring s;
  int i;

  s = message ("map: range to %d\n", map->entries);

  for (i = 0; i < map->entries; i++)
    {
      s = message ("%q%d/%d; ", s, i, map->map[i]);
    }

  s = cstring_appendChar (s, '\n');
  return s;
}

