/*
 * signal.c
 *
 * Installs the signal handlers for the voice code and contains the
 * signal handler functions.
 *
 */

#include "../include/voice.h"

char *libvoice_signal_c = "$Id: signal.c,v 1.3 1996/07/25 19:23:28 marc Exp $";

static int signals_initialized = FALSE;

void *old_sigalrm = SIG_DFL;
void *old_sigchld = SIG_DFL;
void *old_sighup = SIG_DFL;
void *old_sigint = SIG_DFL;
void *old_sigpipe = SIG_DFL;
void *old_sigquit = SIG_DFL;
void *old_sigterm = SIG_DFL;
void *old_sigusr1 = SIG_DFL;
void *old_sigusr2 = SIG_DFL;

static void signal_sigalrm _P1((sig), int sig)
     {
     signal(SIGALRM, signal_sigalrm);
     lprintf(L_JUNK, "%s: got alarm signal", program_name);
     voice_handle_event(SIGNAL_SIGALRM, (event_data) 0);
     };

static void signal_sigchld _P1((sig), int sig)
     {
     signal(SIGCHLD, signal_sigchld);
     lprintf(L_JUNK, "%s: got child termination signal", program_name);
     voice_handle_event(SIGNAL_SIGCHLD, (event_data) 0);
     };

static void signal_sighup _P1((sig), int sig)
     {
     signal(SIGHUP, signal_sighup);
     lprintf(L_JUNK, "%s: got hangup signal", program_name);
     voice_handle_event(SIGNAL_SIGHUP, (event_data) 0);
     };

static void signal_sigint _P1((sig), int sig)
     {
     signal(SIGINT, signal_sigint);
     lprintf(L_JUNK, "%s: got interrupt signal", program_name);
     voice_handle_event(SIGNAL_SIGINT, (event_data) 0);
     };

static void signal_sigpipe _P1((sig), int sig)
     {
     signal(SIGPIPE, signal_sigpipe);
     lprintf(L_JUNK, "%s: got pipe signal", program_name);
     voice_handle_event(SIGNAL_SIGPIPE, (event_data) 0);
     };

static void signal_sigquit _P1((sig), int sig)
     {
     signal(SIGQUIT, signal_sigquit);
     lprintf(L_JUNK, "%s: got quit signal", program_name);
     voice_handle_event(SIGNAL_SIGQUIT, (event_data) 0);
     };

static void signal_sigterm _P1((sig), int sig)
     {
     signal(SIGTERM, signal_sigterm);
     lprintf(L_JUNK, "%s: got terminate signal", program_name);
     voice_handle_event(SIGNAL_SIGTERM, (event_data) 0);
     };

static void signal_sigusr1 _P1((sig), int sig)
     {
     signal(SIGUSR1, signal_sigusr1);
     lprintf(L_JUNK, "%s: got user 1 signal", program_name);
     voice_handle_event(SIGNAL_SIGUSR1, (event_data) 0);
     };

static void signal_sigusr2 _P1((sig), int sig)
     {
     signal(SIGUSR2, signal_sigusr2);
     lprintf(L_JUNK, "%s: got user 2 signal", program_name);
     voice_handle_event(SIGNAL_SIGUSR2, (event_data) 0);
     };

int voice_install_signal_handler _P0(void)
     {
     lprintf(L_NOISE, "%s: installing signal handlers", program_name);

     if (signals_initialized)
          {
          lprintf(L_NOISE, "%s: signal handlers are already installed",
           program_name);
          return(OK);
          };

     old_sigalrm = signal(SIGALRM, signal_sigalrm);
     old_sigchld = signal(SIGCHLD, signal_sigchld);
     old_sighup = signal(SIGHUP, signal_sighup);
     old_sigint = signal(SIGINT, signal_sigint);
     old_sigpipe = signal(SIGPIPE, signal_sigpipe);
     old_sigquit = signal(SIGQUIT, signal_sigquit);
     old_sigterm = signal(SIGTERM, signal_sigterm);
     old_sigusr1 = signal(SIGUSR1, signal_sigusr1);
     old_sigusr2 = signal(SIGUSR2, signal_sigusr2);
     signals_initialized = TRUE;
     return(OK);
     };

int voice_restore_signal_handler _P0(void)
     {
     lprintf(L_NOISE, "%s: restoring signal handlers", program_name);

     if (!signals_initialized)
          {
          lprintf(L_NOISE, "%s: no signal handlers were installed",
           program_name);
          return(OK);
          };

     signal(SIGALRM, old_sigalrm);
     signal(SIGCHLD, old_sigchld);
     signal(SIGHUP, old_sighup);
     signal(SIGINT, old_sigint);
     signal(SIGPIPE, old_sigpipe);
     signal(SIGQUIT, old_sigquit);
     signal(SIGTERM, old_sigterm);
     signal(SIGUSR1, old_sigusr1);
     signal(SIGUSR2, old_sigusr2);
     signals_initialized = FALSE;
     return(OK);
     };
