/*
 * config.h for tiny-getty - This file is part of the tiny-utils package for
 * Linux and ELKS, Copyright (C) 1995, 1996 Nat Friedman <ndf@linux.mit.edu>.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _CONFIG_H
#define _CONFIG_H

/*
 * Define SUPPORT_SERIAL to include support for serial lines in tiny-getty.
 */
#define SUPPORT_SERIAL

/*
 * tiny-getty's program name, as printed in error messages.
 */
#define PROGRAM_NAME       "tiny-getty"

/*
 * The file to read and display before logging the user in.  Set DEFAULT_ISSUE
 * to "" for no issue file.
 */
#define DEFAULT_ISSUE      "/etc/issue"

/*
 * The program to run after accepting the user's username.
 */
#define DEFAULT_LOGIN      "/bin/login"

/*
 * The prompt to display to request the user's username.
 */
#define DEFAULT_PROMPT     "login: "

/*
 * Set to 1 if tiny-getty should set the TERM environment variable.
 */
#define DEFAULT_SET_TERM   0

/*
 * The default value of the TERM environment variable.
 */
#define DEFAULT_TERM       "tty"

/*
 * The default baud rate.
 */
#define DEFAULT_BAUD       38400

/*
 * The UID to which the TTY should be set when it is opened.
 */
#define TTY_OWNER          0

/*
 * The GID to which the TTY should be set when it is opened.
 */
#define TTY_GROUP          5

/*
 * The permissions (in octal!) which should be applied to the TTY when
 * it is opened.
 */
#define TTY_MODE           0622

/*
 * The maximum number of characters the user can type at the login prompt.
 */
#define MAX_LINE_LENGTH    1024

/*
 * The number of bytes to be read at a time from the issue file.
 */
#define PAGE_SIZE          1024

#endif /* _CONFIG_H */


