#include "igdbm.h"
#include "gdbm.h"

/***********************************************************************/
/***********************************************************************/
/***   Utility functions
/***********************************************************************/
/***********************************************************************/

#define RAISE_EXCEPTION(s,ex,type,val)		{ (s)->returnCode=(ex); (s)->_major=CORBA_USER_EXCEPTION; (s)->ptr=(void *)malloc(sizeof(type)); *((type *)(s->ptr))=(val);}
#define RAISE_EXCEPTION_NO_VAL(s,ex)		{ (s)->returnCode=(ex); (s)->_major=CORBA_USER_EXCEPTION; }

#define IGDBM_DATUM_TO_GDBM_DATUM(d1,d2)	{ (d2).dptr=(d1)._buffer; (d2).dsize=(d1)._length; }
#define GDBM_DATUM_TO_IGDBM_DATUM(d1,d2)	{ (d2)._buffer=(d1).dptr; (d2)._length=(d1).dsize; (d2)._maximum=(d1).dsize; }

static char *copystring (char *s)
{
  if (s == NULL)
    return (NULL);
  char *p = (char *) malloc(strlen(s) + 1);
  strcpy (p, s);
  return (p);
}

typedef struct {
  char *filename;
  ilu_boolean readonly;
  GDBM_FILE dbf;
} DB;

#define DB_DBF (db)		(((DB *) ((ILU_C_OBJECT *) (db))->data)->dbf)
#define DB_FILENAME (db)	(((DB *) ((ILU_C_OBJECT *) (db))->data)->filename)
#define DB_READONLY (db)	(((DB *) ((ILU_C_OBJECT *) (db))->data)->readonly)

/***********************************************************************/
/***********************************************************************/
/***   Server operations                                             ***/
/***********************************************************************/
/***********************************************************************/

ilu_CString server_igdbm_Server_Version (igdbm_Server self, CORBA_Environment *s)
{
  return (copystring(gdbm_version));
}

igdbm_Database server_igdbm_Server_Create (igdbm_Server self, CORBA_Environment *s, ilu_CString filename, ilu_integer blockSize, ilu_shortcardinal fileMode)
{
  GDBM_FILE dbf;
  DB *db;

  if ((dbf = gdbm_open (filename, blockSize, GDBM_WRCREAT, fileMode, NULL)) != NULL)
    {
      db = (DB *) malloc(sizeof(DB));
      db->filename = stringcopy (filename);
      db->readonly = ilu_FALSE;
      db->dbf = dbf;
      return (igdbm_Database__CreateTrue (NULL, NULL, (void *) db));
    }
  else
    {
      RAISE_EXCEPTION(s,ex_igdbm_CantCreate,char *,stringcopy(filename));
      return (NULL);
    }
}

igdbm_Database server_igdbm_Server_Open (igdbm_Server self, CORBA_Environment *s, ilu_CString filename)
{
  GDBM_FILE dbf;
  DB *db;

  if ((dbf = gdbm_open (filename, blockSize, GDBM_WRITER, fileMode, NULL)) != NULL)
    {
      db = (DB *) malloc(sizeof(DB));
      db->filename = stringcopy (filename);
      db->readonly = ilu_FALSE;
      db->dbf = dbf;
      return (igdbm_Database__CreateTrue (NULL, NULL, (void *) db));
    }
  else
    {
      RAISE_EXCEPTION(s,ex_igdbm_CantCreate,char *,stringcopy(filename));
      return (NULL);
    }
}

igdbm_Database server_igdbm_Server_OpenReadOnly (igdbm_Server self, CORBA_Environment *s, ilu_CString filename)
{
  GDBM_FILE dbf;
  DB *db;

  if ((dbf = gdbm_open (filename, blockSize, GDBM_READER, fileMode, NULL)) != NULL)
    {
      db = (DB *) malloc(sizeof(DB));
      db->filename = stringcopy (filename);
      db->readonly = ilu_TRUE;
      db->dbf = dbf;
      return (igdbm_Database__CreateTrue (NULL, NULL, (void *) db));
    }
  else
    {
      RAISE_EXCEPTION(s,ex_igdbm_CantCreate,char *,stringcopy(filename));
      return (NULL);
    }
}

/***********************************************************************/
/***********************************************************************/
/***   Database operations                                           ***/
/***********************************************************************/
/***********************************************************************/

ilu_CString igdbm_Database_Filename (igdbm_Database db, CORBA_Environment *s)
{
  return (stringcopy(DB_FILENAME(db)));  
}

ilu_Boolean igdbm_Database_ReadOnly (igdbm_Database db, CORBA_Environment *s)
{
  return (DB_READONLY(db));
}

void igdbm_Database_ReplaceOrAdd (igdbm_Database db, CORBA_Environment *s, igdbm_Datum key, igdbm_Datum value)
{
  if (DB_READONLY(db))
    {
      RAISE_EXCEPTION_NO_VAL(s,ex_igdbm_ReadOnly);
      return;
    }
  else
    {
      datum key2;
      datum val2;
      IGDBM_DATUM_TO_GDBM_DATUM (key, key2);
      IGDBM_DATUM_TO_GDBM_DATUM (value, val2);
      gdbm_store (DB_DBF(db), key2, val2, GDBM_REPLACE);
    }
}

void igdbm_Database_Add (igdbm_Database db, CORBA_Environment *s, igdbm_Datum key, igdbm_Datum value)
{
  if (DB_READONLY(db))
    {
      RAISE_EXCEPTION_NO_VAL(s,ex_igdbm_ReadOnly);
      return;
    }
  else
    {
      datum key2;
      datum val2;
      int ret;

      IGDBM_DATUM_TO_GDBM_DATUM (key, key2);
      IGDBM_DATUM_TO_GDBM_DATUM (value, val2);
      ret = gdbm_store (DB_DBF(db), key2, val2, GDBM_INSERT);
      if (ret == 1)
	{
	  RAISE_EXCEPTION_NO_VAL(s,ex_igdbm_AlreadyPresent);
	}
      else if (ret == -1)
	{
	  RAISE_EXCEPTION(s,ex_igdbm_GDBM_Error,int,gdbm_errno);
	}
    }
}

igdbm_Datum igdbm_Database_Find (igdbm_Database db, CORBA_Environment *s, igdbm_Datum key)
{
  datum key2;
  datum value;
  igdbm_Datum value2;

  IGDBM_DATUM_TO_GDBM_DATUM(key,key2);
  value = gdbm_fetch (DB_DBF(db), key2);
  if (key2.dptr == NULL)
    return (NULL);
  else
    {
      GDBM_DATUM_TO_IGDBM_DATUM(value,value2);
      return (value2);
    }
}

igdbm_RemovalStatus igdbm_Database_Remove (igdbm_Database db, CORBA_Environment *s, igdbm_Datum key)
{
  if (DB_READONLY(db))
    {
      RAISE_EXCEPTION_NO_VAL(s,ex_igdbm_ReadOnly);
      return;
    }
  else
    {
      datum key2;
      int ret;

      IGDBM_DATUM_TO_GDBM_DATUM (key, key2);
      ret = gdbm_delete (DB_DBF(db), key2);
      if (ret == -1)
	return (igdbm_NotPresent);
      else if (ret == 0)
	return (SuccessfullyDeleted);
      else
	{
	  RAISE_EXCEPTION(s,ex_igdbm_GDBM_Error,gdbm_errno);
	  return (0);
	}
    }
}

void igdbm_Database_ReOrganize (igdbm_Database db, CORBA_Environment *s)
{
  if (DB_READONLY(db))
    {
      RAISE_EXCEPTION_NO_VAL(s,ex_igdbm_ReadOnly);
      return;
    }
  else
    {
      gdbm_reorganize (DB_DBF(db));
    }
}
