;;; gnus-art-mime.el --- MIME extension for article mode of Gnus

;; Copyright (C) 1995,1996 Free Software Foundation, Inc.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Created: 1996/8/6
;; Version:
;;	$Id: gnus-art-mime.el,v 0.6 1996/10/21 02:14:23 morioka Exp $
;; Keywords: news, MIME, multimedia, multilingual, encoded-word

;; This file is not part of GNU Emacs yet.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'emu)
(require 'gnus-art)

(autoload 'mime-eword/decode-region "tm-ew-d"
  "Decode MIME encoded-words in region." t)
(autoload 'mime/decode-message-header "tm-ew-d"
  "Decode MIME encoded-words in message header." t)
(autoload 'mime/viewer-mode "tm-view"
  "Major mode for viewing MIME message." t)


(defun gnus-decode-rfc1522 ()
  (goto-char (point-min))
  (if (re-search-forward "^[0-9]+\t" nil t)
      (progn
	(goto-char (point-min))
	;; for XOVER
	(while (re-search-forward "^[0-9]+\t\\([^\t]+\\)\t" nil t)
	  (mime-eword/decode-region (match-beginning 1) (match-end 1)
				    'unfolding 'must-unfold)
	  (if (re-search-forward "[^\t]+" nil t)
	      (mime-eword/decode-region (match-beginning 0)(match-end 0)
					'unfolding 'must-unfold)
	    )
	  ))
    (mime-eword/decode-region (point-min)(point-max) t)
    ))


;;; @ article filter
;;;

(defun gnus-article-preview-mime-message ()
  (make-local-variable 'tm:mother-button-dispatcher)
  (setq tm:mother-button-dispatcher
	(function gnus-article-push-button))
  (let ((mime-viewer/ignored-field-regexp "^:$")
	(default-mime-charset
	  (save-excursion
	    (set-buffer gnus-summary-buffer)
	    default-mime-charset))
	)
    (save-window-excursion
      (mime/viewer-mode nil nil nil gnus-original-article-buffer
			gnus-article-buffer
			gnus-article-mode-map)
      ))
  (run-hooks 'tm-gnus/article-prepare-hook)
  )

(defun gnus-article-decode-encoded-word ()
  (decode-mime-charset-region (point-min)(point-max)
			      (save-excursion
				(set-buffer gnus-summary-buffer)
				default-mime-charset))
  (mime/decode-message-header)
  (run-hooks 'tm-gnus/article-prepare-hook)
  )


;;; @ for BBDB
;;;

(call-after-loaded
 'bbdb
 (function
  (lambda ()
    (require 'tm-bbdb)
    )))

(autoload 'tm-bbdb/update-record "tm-bbdb")

(defun tm-gnus/bbdb-setup ()
  (if (and (boundp 'gnus-article-prepare-hook)
	   (memq 'bbdb/gnus-update-record gnus-article-prepare-hook)
	   )
      (progn
	(remove-hook 'gnus-article-prepare-hook 'bbdb/gnus-update-record)
	(add-hook 'gnus-article-display-hook 'tm-bbdb/update-record)
	)))

(add-hook 'gnus-startup-hook 'tm-gnus/bbdb-setup t)

(tm-gnus/bbdb-setup)


;;; @ end
;;;

(provide 'gnus-art-mime)

;;; gnus-art-mime.el ends here
