/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: transform.h,v 1.1 94/04/26 20:07:26 nau Exp $
 */

/* prototypes for transform routines
 */

#ifndef	__TRANSFORM_INCLUDED__
#define	__TRANSFORM_INCLUDED__

#include "global.h"

/* ---------------------------------------------------------------------------
 * some useful transformation macros
 */
/* ---------------------------------------------------------------------------
 * rotates an object (x,y) in n-90 degree steps around (x0,y0)
 * and save the result in (xd,yd)
 */
#define	ROTATE(x,y,x0,y0,n)									\
	{														\
		Position	dx = (x)-(x0),							\
					dy = (y)-(y0);							\
															\
		switch(n)											\
		{													\
			case 1:		(x)=(x0)+dy; (y)=(y0)-dx; break;	\
			case 2:		(x)=(x0)-dx; (y)=(y0)-dy; break;	\
			case 3:		(x)=(x0)-dy; (y)=(y0)+dx; break;	\
			default:	break;								\
		}													\
	}
#define	ROTATE_VIA(v,x0,y0,n)	ROTATE((v)->X,(v)->Y,(x0),(y0),(n))
#define	ROTATE_PIN(p,x0,y0,n)	ROTATE((p)->X,(p)->Y,(x0),(y0),(n))

/* ---------------------------------------------------------------------------
 * moves an object (xs,ys) by (deltax,deltay)
 */
#define	MOVE(xs,ys,deltax,deltay)							\
	{														\
		((xs) += (deltax));									\
		((ys) += (deltay));									\
	}
#define	MOVE_VIA(v,dx,dy)	MOVE((v)->X,(v)->Y,(dx),(dy))
#define	MOVE_PIN(p,dx,dy)	MOVE((p)->X,(p)->Y,(dx),(dy))
#define	MOVE_LINE(l,dx,dy)									\
	{														\
		MOVE((l)->X1,(l)->Y1,(dx),(dy))						\
		MOVE((l)->X2,(l)->Y2,(dx),(dy))						\
	}
#define	MOVE_RECT(r,dx,dy)	MOVE((r)->X,(r)->Y,(dx),(dy))
#define	MOVE_TEXT(t,dx,dy)	MOVE_RECT(&((t)->Rect),(dx),(dy))	\
	{														\
		MOVE_RECT(&((t)->Rect),(dx),(dy));					\
		MOVE((t)->X, (t)->Y, (dx), (dy));					\
	}

/* ---------------------------------------------------------------------------
 * prototypes
 */
void	RotateLine(LineTypePtr, Position, Position, BYTE);
void	RotateRect(RectTypePtr, Position, Position, BYTE);
void	RotateText(TextTypePtr, Position, Position, BYTE);
void	RotateArc(ArcTypePtr, Position, Position, BYTE);
void	RotateElement(ElementTypePtr, Position, Position, BYTE);
void	MoveElement(ElementTypePtr, Position, Position);
Boolean	MoveAndRotateAllInRectangle(Position, Position, Position, Position,
			Position, Position, Position, Position, BYTE);
Boolean	ChangeViaSize(PinTypePtr, int);
Boolean	ChangePinSize(PinTypePtr, int);
Boolean	ChangeLineSize(LineTypePtr, LayerTypePtr, int);
Boolean	ChangeLineSizeInRectangle(Position, Position, Position, Position, Position);
Boolean	ChangeViaSizeInRectangle(Position, Position, Position, Position, Position);
Boolean	ChangePinSizeInRectangle(Position, Position, Position, Position, Position);

#endif
