

// -------------------------------------------------------------------------
// -- Define Maelstrom

#ifndef __MAELSTROM__
#define __MAELSTROM__
#endif


/* ----------------------------------------------------------------- */
/* -- #define's */

#define ULONG			unsigned long

#define	FUDGE_DELAY		(5L * 60L)
#define	SOUND_DELAY		6
#define	SHARE_PIC_SIZE		13334

#define	SLEEP			1

#define	VERSION_STRING		"1.4.1"
#define	SPARE_MEMORY		(16L * 1024L)
#define	VEL_FACTOR		4

#define	ESC			50
#define	SOUND_SIGNATURE		132
#define	SCREEN_DEPTH		8
#define	ICON_SIZE		128L
#define	SPRITE_BYTES		1024L
#define	SMALL_SPRITE_BYTES	256L
#define	SMALL_ICON_SIZE		32L

#ifndef PI
#define	PI			(22.0 / 7.0)
#endif

#define	BLUE_MOON		50
#define	MOON_FACTOR		4

#define	MIN_DISTANCE		200
#define	MIN_BAD_DISTANCE	64
#define	STEEL_SPECIAL		10
#define	SHAKE_FACTOR		256
#define	ERROR_ALERT		128
#define	ERROR_STRINGS		128
#define	NO_SCREEN_ALERT		1
#define	NO_MEMORY		2
#define	BAD_SYSTEM_VERS		5
#define	TAMPERED_WITH		6
#define	SOUND_PROBLEM		17

#define	ANIM_BOUNDRY		40
#define	SPRITES_WIDTH		32
#define	SPRITE_PRECISION	4
#define	SCALE_FACTOR		16
#define	SHIP_FRAMES		48
#define	ICON_SIZE		128L
#define	INITIAL_BONUS		2000L
#define	SAFE_DISTANCE		40
#define	NEW_LIFE		50000
#define	LUCK_ODDS		3
#define	FADE_STEPS		40

#define	ENEMY_SHOT_DELAY	10
#define	SHAKE_DURATION		(5 * 60)
#define	SHIELD_WIDTH		55
#define	MAX_SHIELD		(60 * 5)
#define	MAX_SPRITE_FRAMES	60
#define	MAX_SPRITES		100
#define	VEL_MAX			(8<<SPRITE_PRECISION)
#define	MAX_SCRN_WIDTH		640
#define	MAX_SCRN_HEIGHT		480
#define	MAX_STARS		30
#define	MAX_SHOTS		18
#define	NUM_PRIZES		8

#define	GRAVITY_MOVE		3
#define	HOMING_MOVE		6
#define	STATUS_HEIGHT		14
#define	KILL_SPRITE		7
#define	HIDE_SPRITE		5

#define	SHOTS_DELAY		2	// delay in ticks between drawing shots
#define	FRAME_DELAY		2	// delay in ticks between frames
#define KEYBOARD_DELAY		2	// delay in ticks between keyboard polls
#define	BOOM_MIN		20
#define	DEAD_DELAY		(3 * 60)
#define	STAR_DELAY		30
#define	BONUS_DELAY		30
#define	HOUSEKEEPING_DELAY	20
#define	DISPLAY_DELAY		60
#define	SAFE_TIME		120L
#define	THRUST_DELAY		1
#define	POST_DELAY		(60 * 60)
#define	FREEZE_DURATION		(10 * 60)

#define	BLACK			0xFFFFFFFF
#define	NO_PHASE_CHANGE		-1
#define	NUM_SND_CHANNELS	1

#define	PRIZE_DURATION		(10 * 60)
#define	MULT_DURATION		(6 * 60)
#define	BONUS_DURATION		(10 * 60)
#define	SHOT_DURATION		(1 * 60)
#define	POINT_DURATION		(2 * 60)
#define	DAMAGED_DURATION	(10 * 60)

#define	SHOT_SCALE_FACTOR	4
#define	SHOT_SIZE		4
#define	HOMING_HITS		9
#define	ENEMY_HITS		3
#define	INITIAL_SHIELD		(60 * 3)

#define	PLAYER_SHIP		1
#define	BIG_ASTEROID		2
#define	MEDIUM_ASTEROID		3
#define	SMALL_ASTEROID		4
#define	EXPLOSION		5
#define	MULTIPLIER		6
#define	STEEL_ASTEROID		7
#define	PRIZE			8
#define	BONUS			9
#define	HOMING_PIGEON		10
#define	GRAVITY			11
#define	NOVA			12
#define	DAMAGED_SHIP		13
#define	THRUSTER		14
#define	ENEMY_SHIP		15
#define	SMALL_ENEMY		16
#define	BIG_ENEMY		17
#define	CRAZY_ENEMY		18

#define	SMALL_ROID_PTS		300
#define	MEDIUM_ROID_PTS		100
#define	BIG_ROID_PTS		50
#define	GRAVITY_PTS		500
#define	HOMING_PTS		700
#define	NOVA_PTS		1000
#define	STEEL_PTS		100
#define	ENEMY_PTS		1000

/* -- Flags for the player's ship */

#define	SHIP_ALIVE		1
#define	SHIP_DEAD		0

/* -- Flags for controlling the ship */

#define	SHIFT	63
#define	CAPS	62
#define	OPTION	61
#define	CONTROL	60
#define	COMMAND	48
#define	SPACE	54

#define	SPRITES_NAME	"Maelstrom Sprites"

#define	MOUSE_POS_1	0x000F000F
#define	MOUSE_POS_2	0x000A000A

/* ----------------------------------------------------------------- */
/* -- Structures and typedefs */

typedef struct {
	int h;
	int v;
	} MPoint;

/* The controls structure */
typedef struct {
	unsigned short	gPauseControl;
	unsigned short	gShieldControl;
	unsigned short	gThrustControl;
	unsigned short	gTurnRControl;
	unsigned short	gTurnLControl;
	unsigned short  gFireControl;
	unsigned short	gQuitControl;
	} Controls;

typedef	struct {
	char	name[20];
	int	wave;
	ULONG	score;	
	} Scores;

typedef struct {
	int		xCoord;
	int		yCoord;
	int		color;
	} Star;
typedef Star* StarPtr;

typedef struct {
	int	shotVis;
	int	virgin;
	int	xVel;
	int	yVel;
	int	xCoord;
	int	yCoord;
	ULONG	fireTime;
	Rect	hitRect;
	} Shot;
typedef Shot* ShotPtr;
	
typedef	struct {
	int      numFrames;
	int      isSmall;
	Rect     hitRect;
	CSprite *sprite[MAX_SPRITE_FRAMES];
	unsigned char *spriteImages[MAX_SPRITE_FRAMES];
	unsigned char *imageMasks[MAX_SPRITE_FRAMES];
	} Blit;
typedef Blit* BlitPtr;
	
typedef struct {
	int     onScreen;
	int	visible;
	long	spriteType;
	long	spriteTag;
	
	int	xVel;
	int	yVel;
	int	xCoord;
	int	yCoord;
	int	oldXCoord;
	int	oldYCoord;
	int	hitFlag;
	
	int	numPhases;
	int	phaseOn;
	int	phaseChange;
	int	changeCount;
	Blit   *theBlit;
	} Sprite;
typedef Sprite* SpritePtr;
