
/* Written by Peter Ekberg, peda@lysator.liu.se */

#ifndef THRUST_H
#define THRUST_H

/* The speed of the game. Gravity and thrust is affected.
   Don't try too large values. 256 is what it used to
   be in the good old days. */

#define SPEED 180

/* Uncomment the following define if you have an old version of
   svgalib (i.e version < 1.2.8) */
/*
#define SCANCODE_P 25
*/


/* How many levels and what they are named. */

#define LEVELS (4)
extern char *level1[];
extern char *level2[];
extern char *level3[];
extern char *level4[];


#include <vga.h>
#include <vgagl.h>



#define VGAMODE G320x200x256

#define BBILDX	(41)
#define BBILDY	(23)
#define PBILDX	(BBILDX*8)
#define PBILDY	(BBILDY*8)
#define PSCRX	(PBILDX-8)
#define PSCRY	(PBILDY-8)

#define incr(x,max,return) \
{ \
    (x)++; \
    if((x)>=(max)) \
      (x)=(return); \
}
#define decr(x,min,return) \
{ \
    (x)--; \
    if((x)<(min)) \
      (x)=(return)-1; \
}

#define gcenter(y,s) (printgs(160-(gstrlen(s)>>1), (y), (s)))

typedef enum { INST, PLAY, HI, ABOUT, END, KEYS, NOTHING, DEMO } options;

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;

struct bulletdef {
  int life,x,y,vx,vy,dir,owner;
};
typedef struct bulletdef bullet;
struct fragmentdef {
  int life,x,y,vx,vy;
};
typedef struct fragmentdef fragment;
struct thingdef	{
  int alive,px,py,x,y,type,score;
  void *data;
};
typedef struct thingdef thing;
extern word nrthings;
struct sliderdef {
  int type,x1,y1,x2,y2,dir,active,stage,count,match;
  struct sliderdef *next;
};
extern word nrsliders;
typedef struct sliderdef slider;
struct buttondatadef {
  int major;
  int tag;
  slider *sliders;
};
typedef struct buttondatadef buttondata;
struct restartpointdef {
  word x, y;
};
extern word nrrestartpoints;
typedef struct restartpointdef restartpoint;
struct barrierdef {
  word x, y;
  restartpoint *restart;
};
extern word nrbarriers;
typedef struct barrierdef barrier;

extern unsigned char intro[];
extern unsigned char bin_blocks[];
extern unsigned char bin_ship[];
extern unsigned char bin_shield[];
extern unsigned char bin_colors[];
extern unsigned char bin_bullets[];
extern unsigned char bin_demomoves[];

extern int scancode[];
extern char *keynames[];

extern void putscr(int x,int y);
extern void putblock(int x, int y, byte *source);
extern void writeblock(word bx, word by, byte block);
extern void drawship(word bx, word by, byte *ship, byte *storage);
extern void undrawship(word bx, word by, byte *storage);
extern void drawsquare(word bx, word by,
		       byte *object, byte *storage, byte deltax, byte deltay);
extern void undrawsquare(word bx, word by,
			 byte *storage, byte deltax, byte deltay);
extern word testcrash(byte *object, byte *storage, word len, byte shield);
extern void fadepalette(word first, word last, Palette *RGBtable,
			word fade, word flag);
extern void setmargin(byte color, byte flag);
extern byte *bild;

extern byte *bulletmap;
extern Palette *palette;
extern byte *blocks;
extern byte *ship;
extern byte *shieldship;
extern byte *bana;
extern byte *fuelmap;
extern byte *loadmap;
extern byte *shipstorage;
extern byte *bulletstorage;
extern byte *fragmentstorage;
extern byte *fuelstorage;
extern byte *loadstorage;
extern byte *wirestorage;

#define maxbullets (64)
extern bullet bullets[maxbullets];
#define maxfragments (512)
extern fragment fragments[maxfragments];
#define maxthings (32)
extern thing things[maxthings];
#define maxsliders (32)
extern slider sliders[maxsliders];
#define maxbarriers (512)
extern barrier barriers[maxbarriers];
#define maxrestartpoints (16)
extern restartpoint restartpoints[maxrestartpoints];

extern word spacestation;
extern word ssx,ssy,scount;	/* Spacestation-variables */
extern word ssblip;

#define maxlenx ((word)BBILDX*12) /*max 48 skrmar a 41*23 tecken a */
#define maxleny ((word)BBILDY*4) /* 8*8 pixels a 8 bitar, dvs. 3274752 bytes.*/

extern word lenx; /* Banans max i x-len, anvnds senare till den aktuella */
extern word leny; /* Banans max i y-len, storleken p banan.Stts i readbana */
extern word lenx3,leny3;

extern int sinus[32];
extern int sinus2[1024];
extern int arcsinus[25];

extern int alpha,deltaalpha;
extern word loaded,loadcontact,loadpointshift;
extern int loadpoint;
extern int countdown;
extern word crash,shoot,repetetive;
extern word refueling;
extern int speedx,speedy;
extern long absspeed,oldabs;
extern int kdir,dir;
extern int shipdx,shipdy;
extern int x,y;
extern int pixx,pixy;
extern int pblockx,pblocky;
extern int vx,vy;
extern int bildx,bildy;
extern int bblockx,bblocky;
extern int loadbx,loadby;
extern int gravity;
extern int score;
extern byte shield;
extern byte colorr, colorg, colorb;

void fade_in();
void fade_out();
void newslider(int x, int y, int type);
void animatesliders(void);
int majorbutton(int button);
int closestbutton(int x, int y);
void newthing(int x, int y, int px, int py, int type, void *data);
void deletething(thing *tp, int dx, int dy, int sx, int sy);
int insideblock(int blockx, int blocky,
		int pblockx, int pblocky, int sx, int sy);
int insidepixel(int x, int y, int pixx, int pixy, int sx, int sy);
int readbana(char **ptr);
void releasebana(void);
void updateborder(int pblockx, int pblocky,
		  int bblockx, int bblocky, int vx, int vy);
word crashtype(word type);
int resonablefuel(int x, int y, int l);
int closestfuel(int x, int y);
void hit(word x, word y, word crash, word owner);
void bunkerfire(thing *b);
void turnship();
void makefuelmap(dword *fuelmap);
int initmem();
void inithardware();
void initscreen(int round);
void restorehardware();
void restoremem();
void drawteleport();
word drawshuttle();
void initgame(int round, int reset, int xblock, int yblock);
int inloadcontact(int x, int y);
void bunkerfirebullets();
void drawfuel(int fuel);
void drawload(int flag);
void drawspacestationblip();
void drawfuellines();
void undrawfuellines();
void undrawshuttle();
int killdyingthings();
void explodething(thing *thingptr);
void explodeship(void);
void newbullet(word x, word y, int vx, int vy, word dir, int owner);
void movebullets();
void wrapbullets();
void unwrapbullets();
void drawbullets();
void undrawbullets();
void newfragment(word x, word y);
void movefragments();
void wrapfragments();
void unwrapfragments();
void drawfragments();
void undrawfragments();
word livefragments();
void savegraphics(int x, int y);
restartpoint *atbarrier(word bx, word by);

void printgc(word offset, byte ch);
int printgs(int x, int y, char *string);
int readgs(int x, int y, char string[], int maxc, int maxp, char flag);
int gstrlen(char *string);
extern byte chcolor, chpaper, chflag;
void changekeys();

#define HIGHSCORES (5)
typedef struct {
  char name[40];
  int score;
} highscoreentry;
int inithighscorelist(void);
char *standardname(void);
int ahighscore(int score);
void inserthighscore(char *name, int score);
void writehighscores(void);
extern highscoreentry highscorelist[HIGHSCORES];

extern byte font[256][6];

#define min(x,y) \
 (((x)<(y))?(x):(y))

#define max(x,y) \
 (((x)<(y))?(y):(x))

#endif /* THRUST_H */
