/*
 * Programm XBLAST V2.0 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 14th 1996
 * started August 1993
 *
 * File: mytypes.h
 * types declarations
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MYTYPES_H
#define _MYTYPES_H

/*
 *  PFV Pointer to void functions
 */

typedef void (*PFV)();



/*
 *  position vector
 */
typedef struct {
  int y,x;
} BMPosition;

/*
 * Pointer to bitmap data
 */
typedef struct {
  int width, height;
  unsigned char *data;
} BitmapStruct;


/* player to display relation */
typedef struct {
  int num;
  int p1, p2;
} DispPlayer;


/*
 * Database entries
 */
typedef struct {
  char *name;
  char *value;
} BMEntry;

/*
 * config parameters 
 */
typedef struct {
  int num_player;
  int num_disp;
  int default_disp;
  char *display[MAX_PLAYER];
  int pl_at_disp[MAX_PLAYER];
  DispPlayer disp_player[MAX_PLAYER];
  int use_X_resources;
} XBConfig;

/*
 *  Setup parameters
 */

typedef struct {
  int max_victories;
  int max_lives;
  int start_level;
  int random_mode;
  int random_spos;
  int sound_flag;
  int frame_time;
  int color_mode;
  int print_stat;
  int use_level[LEVEL_MAX];
} XBSettings;

/*
 * Extra Probabilities
 */

typedef struct 
{
  int bomb;
  int range;
  int ill;
  int invinc;
  int evil;
} BMExtraProb;

/*
 * Block tile definition
 */

typedef struct {
  int id;
  char *fg;
  char *bg;
  char *add;
} BMBlockTile;

/* 
 * shrink element structure 
 */

/* generic shrink data */
typedef struct {
  int time;
  int block;
  int x,y;
} ShrinkGeneric;

/* spiral shrink data */
typedef struct {
  int time;
  int block;
  int range;
  int time_incr;
  int start_pos;
} ShrinkSpiral;

/* rows shrink data */
typedef struct {
  int time;
  int block;
  int pos;
  int horizontal;
} ShrinkLine;

/* gd shrink data */
typedef struct {
  int x,y;
  int offset;
  int level;
} shri_data;

typedef int shri_xoff_data;

typedef struct {
  int offset;
  int level;
  int block;
} shri_style2;

typedef struct {
  int num;
  shri_style2 *styl;
} shri_style;

/* Scramble Structure */
typedef struct {
  int time;
  int num_blocks;
  BMPosition *blocks;
} ScrambleStruct; 

/*
 *  Leveldata Struct
 */

typedef struct {
  char *name;
  char *author;
  char *resource;
  long game_mode;
  ScrambleStruct scrdraw, scrdel;
  PFV shrink_func;
  PFV init_func;
  PFV game_func;
  PFV extra_func;
  PFV key_func;
  BMPosition position[MAX_PLAYER];
  int range,bombs,bomb_dir; 
  int init_flags, init_health;
  int fuse_time, defaultBMT, buttonBMT, evilBMT;  
  BMExtraProb prob;
  BMBlockTile block[MAX_BLOCK];
  int shadow;
  int distrib_extras;
  int bomb_click;
  int wall_click;
  int player_click;
  char *DSCtips;
  int maze[MAZE_W][MAZE_H];
} BMLevelData; 
 
typedef struct {
  char *title1, *title2;
  char *lighttext1, *lighttext2;
  char *darktext1, *darktext2;
  char *statusled, *statusfg, *statusbg;
  char *expl1, *expl2, *expl3;
} DisplayColor;

typedef struct {
  char *helmet;
  char *face;
  char *body;
  char *hands_feet;
  char *arms_legs;
  char *backpack;
} PlayerColor;

typedef struct {
  int helmet;
  int face;
  int body;
  int hands_feet;
  int arms_legs;
  int backpack;
} PlayerColorCell;

typedef struct {
  PFV func;
  char *msg;
} FuncInfo;

/*
 * BMPlayer 
 */

typedef struct
{
  int y,x;
  int anime;
  int d_soll,d_ist,d_look;
  int invincible;
  int next_blink;
  int dying;
  int stunned;
  int illness;
  int illtime;
  int junkie;
  int junkie_time;
  int health;
  int lives;
  int score;
  int range;
  int bombs;
  unsigned int extra_flags;
  int special_bombs;
  int remote_control;
  int kick;
  int air_button;
  int victories;
  int teleport;
  int num_extras;
  int abort;
} BMPlayer;

typedef struct {
  char *name;
  char *winlevel;
  char *wingame;
  char *loselife;
  char *loselevel;
  char *gloat;
  char *welcome;
  char *abort;
  char *abortcancel;
} PlayerStrings;

/* player action at last turn */
typedef struct {
  int dir;
  int bomb;
  int special;
  int pause;
  int abort;
} PlayerAction;

/*
 * Sprites
 */

typedef struct {
  int type;
  int ysort;
  int x,y;
  int mode;
  int player,anime;
} PlayerSprite;

typedef struct {
  int type;
  int ysort;
  int x,y;
  int mode;
  int anime;
} ExplosionSprite;

typedef struct {
  int type;
  int ysort;
  int x,y;
  int mode;
} AnySprite;

typedef union {
  int             type ;
  AnySprite       any;
  PlayerSprite    player;
  ExplosionSprite expl;
} Sprite;
    


typedef struct explosion {
  int player;
  int range;
  int x,y;
  int dx,dy;       /* small deviations from x and y */
  int dir;         /* Direction */
  int malfunction; /* flag for malfunction illness */
  int count;
  int blink;
  int type;
  int type_extr;
  struct explosion *next;
} Explosion;


typedef struct {
  double x,y;
} BMPoint;

typedef struct {
  int x, y;
  int w, h;
} BMRectangle;

typedef struct {
  int fg, bg, add;
} XBColorTriple;
#endif
/*
 * end of ile mytype.h
 */









