#ifndef FORMULAS_H
#define FORMULAS_H

#include "config.h"

#define INCOLORING 2
#define OUTCOLORING 7
#define PLANES 7
#define MAX_LAMBDA 2

typedef struct {
    number_t mc, nc;
    number_t mi, ni;
} vinfo;

typedef struct {
    number_t y0, k;
} symetry;

struct symetryinfo {
    number_t xsym, ysym;
    int nsymetries;
    symetry *symetry;
};

struct formula {
    int (*calculate) (number_t, number_t, number_t, number_t) REGISTERS(3);
    char *name[2];
    vinfo v;
    int mandelbrot;
    number_t pre, pim;
    struct symetryinfo out[OUTCOLORING];
    struct symetryinfo in[INCOLORING];
};

extern struct formula formulas[];
extern char *incolorname[];
extern char *outcolorname[];
extern CONST int nformulas;
extern int coloringmode;
extern int incoloringmode;

#endif				/* FORMULAS_H */
