$! Modified VMSMAKE for SLRN - Andy Harper, Kings College London
$!	- Use logicals to define SLANG location, if defined	[16-MAY-1996]
$!	- A few bug fixes!					[16-MAY-1996]
$!	- Auto-detect TCP stack and C compiler type	[14-NOV-1995]
$!	- Override auto-selection of TCP stack via P1	[14-NOV-1995]
$!
$ SLRNLIB := "LIB$:[NEWS]"
$ SLANGLIB = "[-.-.slang.src]"
$ SLANGOBJ = SLANGLIB + "SLANG.OLB"				! AH 16-MAY-1996
$
$!
$! If logical names defining the location of the slang libraries and header
$! files exist, use them in preference to the above definition of SLANGLIB
$!	-  SLANG_ROOT:[SRC] = location of header files (slang.h)
$!	-  SLANG_LIBRARY    = (if defined) location of SLANG.OLB
$!			      (if not defined) SLANG_ROOT:[SRC]SLANG.OLB used
$
$ if f$trnlnm("SLANG_ROOT") .nes. ""			! AH 16-MAY-1996
$   then						! AH 16-MAY-1996
$     SLANGLIB := "SLANG_ROOT:[SRC]"			! AH 16-MAY-1996
$     if f$trnlnm("SLANG_LIBRARY") .nes. ""		! AH 16-MAY-1996
$       then						! AH 16-MAY-1996
$         SLANGOBJ = "SLANG_LIBRARY"			! AH 16-MAY-1996
$       else						! AH 16-MAY-1996
$         SLANGOBJ = SLANGLIB  +  "SLANG.OLB"		! AH 16-MAY-1996
$     endif						! AH 16-MAY-1996
$ endif							! AH 16-MAY-1996
$
$!
$!
$! Determine TCP stack availability (NOTE - order of test is important!)
$ TCP = "NONE"
$ if f$trnlnm("UCX$INET_HOST","LNM$SYSTEM") .nes. "" then $ TCP = "UCX"
$ if f$trnlnm("MULTINET",     "LNM$SYSTEM") .nes. "" then $ TCP = "MULTINET"
$ if f$trnlnm("NETLIB_DIR",   "LNM$SYSTEM") .nes. "" then $ TCP = "NETLIB"
$!
$ if P1 .nes. "" then $ TCP = P1	! Override via user parameter
$!
$ if TCP .eqs. "NONE"
$   then
$     write sys$error "%VMSMAKE-E-NONETWORK, Cannot determine which TCP stack you have"
$     exit
$ endif
$ write sys$output "%VMSMAKE-I-TCPFOUND, Building with the ", TCP, " network interface"
$!
$!
$! Determine which C compiler
$ if f$search("SYS$SYSTEM:DECC$COMPILER.EXE") .nes. ""
$   then ! DEC C
$     COMPILER = "DEC C"
$     PREFIX := "/PREFIX=(ALL,EXCEPT=(SOCKET,CONNECT,BIND,LISTEN,SOCKET_READ,SOCKET_WRITE,SOCKET_CLOSE,SELECT,ACCEPT,BCMP,BCOPY,BZERO,GETHOSTBYNAME,GETHOSTBYADDR,GETPEERNAME,GETDTABLESIZE,HTONS,HTONL,NTOHS,NTOHL,SEND,SENDTO,RECV,RECVFROM))"
$     CCOPT = ""
$   else ! VAX C
$     COMPILER = "VAX C"
$     PREFIX := ""
$     CCOPT = ", SYS$DISK:[]VAXC.OPT/OPTION"
$     DEFINE SYS SYS$LIBRARY
$ endif
$ write sys$output "%VMSMAKE-E-CC, Building with ", COMPILER
$!
$!
$! Define key macros and other flags
$ DEFS := "''TCP',SLRN_LIB_DIR=""""""""""""''SLRNLIB'"""""""""""""
$ CFLAGS := "/INCLUDE=(''SLANGLIB') /DEFINE=(''DEFS') /nowarning ''PREFIX'"
$!
$ LFLAGS := "/NODEBUG"
$!
$!
$! Build
$ copy slrnconf.h config.h
$ purge config.h
$ CC/INCLUDE=('SLANGLIB') CHKSLANG.C
$ LINK/EXEC=CHKSLANG.EXE CHKSLANG.OBJ 'CCOPT'
$ CHKSLANG := $SYS$DISK:[]CHKSLANG
$ CHKSLANG SLRN 9930 9930
$ v = f$verify(1)
$ CC 'CFLAGS' SLRN.C
$ CC 'CFLAGS' GROUP.C
$ CC 'CFLAGS' MISC.C
$ CC 'CFLAGS' SERVER.C
$ CC 'CFLAGS' ART.C
$ CC 'CFLAGS' POST.C
$ CC 'CFLAGS' STARTUP.C
$ CC 'CFLAGS' HELP.C
$ CC 'CFLAGS' HASH.C
$ CC 'CFLAGS' VMS.C
$ CC 'CFLAGS' SCORE.C
$ CC 'CFLAGS' VMSMAIL.C
$ CC 'CFLAGS' MIME.C
$ CC 'CFLAGS' UUDECODE.C					! AH 24-MAY-1996
$ CC 'CFLAGS' MENU.C
$ LINK/EXEC=SLRN.EXE 'LFLAGS' slrn.obj,group.obj,misc.obj,server.obj,-
	art.obj,post.obj,startup.obj,help.obj,hash.obj,vms.obj,score.obj, -
	mime.obj,vmsmail.obj,menu.obj,uudecode.obj, -		! AH 24-MAY-1996
	'SLANGOBJ'/LIBR, SYS$DISK:[]'TCP'.OPT/OPTION 'CCOPT'	! AH 16-MAY-1996
$ v=f$verify(v)
