.\" $Id: xinput.man,v 1.1.1.1 1996/10/17 04:32:12 fred Exp $
.TH xinput 1 "$Date: 1996/10/17 04:32:12 $" "Frederic Lepied"

.SH NAME
xinput - utility to configure and test XInput devices

.SH SYNOPSIS
.B xinput
[version] [list [\fIdevice_name\fP]] [set-pointer \fIdevice_name\fP]
[set-mode \fIdevice_name\fP \fIABSOLUTE|RELATIVE\fP]
[set-ptr-feedback \fIdevice_name\fP \fIthreshold\fP \fInum\fP \fIdenom\fP]
[set-button-map \fIdevice_name\fP \fImap button 1\fP [\fImap button 2\fP [\fI...\fP]]]
[test \fIdevice_name\fP]

.SH DESCRIPTION
.TP 8
.B xinput version
test if the XInput extension is available and return the version number
of the program.
.PP
.TP 8
.B xinput list [\fIdevice_name\fP]
If no argument is given list all the input devices showing all their
features. If an argument is given, show all the feature of \fIdevice_name\fP.
.PP
.TP 8
.B xinput set-pointer \fIdevice_name\fP
Switch \fIdevice_name\fP in core pointer.
.PP
.TP 8
.B xinput set-mode \fIdevice_name\fP \fIABSOLUTE|RELATIVE\fP
Change the mode of \fIdevice_name\fP.
.PP
.TP 8
.B xinput set-ptr-feedback \fIdevice_name\fP \fIthreshold\fP \fInum\fP \fIdenom\fP
Change the acceleration of \fIdevice_name\fP.
.PP
.TP 8
.B xinput set-button-map \fIdevice_name\fP \fImap button 1\fP [\fImap button 2\fP [\fI...\fP]]
Change the button mapping of \fIdevice_name\fP.
.PP
.TP 8
.B xinput test \fIdevice_name\fP
Register all extended events from \fIdevice_name\fP and enter an endless
loop displaying events received.
.PP

.SH COPYRIGHT
Copyright 1996, Frederic Lepied.

.SH AUTHOR

.nf
Frederic Lepied, France <Frederic.Lepied@sugix.frmug.org>
.fi

Patches, bug reports, and suggestions are welcome.
