#ifndef OIDTBL_H
#define OIDTBL_H 1
/*
 * oidtbl.h -- implementation of OID tables -- mappings between OIDs and
 *	       (void *)s
 *
 * Antony Courtney,	23/6/95
 */

/* gss_oidtbl_t -- OID table abstract type */
typedef void *gss_oidtbl_t;

/* _ilugss_oidtbl_create() -- create an OID table, mapping keys (OIDs) to (void *)s
 */
gss_oidtbl_t _ilugss_oidtbl_create(void);

/* _ilugss_oidtbl_insert() -- insert a mapping into an OID table */
void _ilugss_oidtbl_insert(gss_oidtbl_t tbl,gss_OID key,void *val);

/* _ilugss_oidtbl_find() -- lookup a value for a particular OID
 * returns: pointer to which OID is mapped on success, NULL if OID is not in
 *	    table
 */
void *_ilugss_oidtbl_find(gss_oidtbl_t tbl,gss_OID key);

void _ilugss_oidtbl_enumerate(gss_oidtbl_t, void(*)(gss_OID,void *,void *), void *rock);
/* call func on each member of the table with the key value, the data value,
   and the user-specified rock */

int _ilugss_oidtbl_size(gss_oidtbl_t);

/* _ilugss_oidtbl_destroy() -- destroy an OID table */
void _ilugss_oidtbl_destroy(gss_oidtbl_t tbl);

#endif	/* OIDTBL_H */
