/* IluDataSupport.java */
/* Chris Jacobi, August 18, 1997 7:55 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* 
 * $Id: IluDataSupport.java,v 1.2 1997/08/20 22:00:18 jacobi Exp $ 
 */
 
package xerox.ilu;

/**
 * An object implementation can help ILU by remembering 
 * internal data. Object which do not provide this
 * help may still be used but might not be exposed to
 * garbage collection and could be hold on permanently.<p>
 *
 * If this interface is exported, ILU calls the setIluData 
 * procedure and asks the object to remember the argument. <br>
 * A paranoid implementation of this interface may take advantage 
 * of the fact that ILU calls setIluData at most once per object. <p>
 *
 * Whenever ILU needs its internal data it will call getIluData.<p>
 *
 * ILU expects that the internal data is not garbage collected
 * before the ILU object itself is garbage. (This means that
 * ILU object's may NOT be "resurected".<br>
 *
 * ILU calls this from within and from outside its locks;
 * the safest way to avoid deadlock is to not call any locking 
 * operation which can interfear with locks held by ILU.<br>
 *
 * @see Ilu
 */
public interface IluDataSupport extends xerox.ilu.IluObject {
    public void setIluData(java.lang.Object internal);
    public java.lang.Object getIluData();
}
