/* xerox.ilu.IluServantFinalizable.java */
/* Chris Jacobi, July 6, 1997 1:11 pm PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluServantFinalizable.java,v 1.1 1997/07/06 20:36:04 jacobi Exp $ */
 
package xerox.ilu;

/**
 * A server object can implement this interface to
 * request a call of iluServantFinalize on its real
 * finalization time.  Please no resurection or
 * other fancy usage.  <p>
 *
 * This serves as a general replacement for finalize because
 * Ilu forbids clients to use finalize directly.  Clients
 * also must use corba_ServantFinalizer for this to work
 * on non ilu orbs.
 *
 * @see corba_ServantFinalizer if this were made a omg standard
 */
public interface IluServantFinalizable {
    public void iluServantFinalize() throws java.lang.Throwable;
}
