// svec.h					emacs, this is a -*-c++-*- file
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

#ifndef SVEC_H
#define SVEC_H

#include <stdlib.h>

template<class T>
class Svec
{
public:
    Svec(int max = 16);
    Svec(const Svec<T> &s);
    ~Svec();

    Svec<T> &operator=(const Svec<T> &s);
    int size() const { return used; };
    void setSize(int newsize);
    T &operator[](int i)
        { if(i < 0 || i >= used) indexerr(i); return vect[i]; };
    T operator[](int i) const
	{ if(i < 0 || i >= used) indexerr(i); return vect[i]; };
    void set(int i, T val)
	{ if(i < 0 || i >= used) setextend(i, val); else vect[i] = val; };
    void sort(int (*compare)(T *a, T *b));
    void add(T x) { if(++used > alloced) grow(); vect[used - 1] = x; };
    void remove(int index);
    void clear() { used = 0; };
    void purge();		// like clean() but deletes all contents

private:
    void grow() { vect = (T *)realloc(vect, (alloced *= 2) * sizeof(T)); };
    void setextend(int index, T value);
    void indexerr(int index) const;

    T *vect;
    int alloced;		// # of entries allocated
    int used;			// # of entries actually used (size)
};

#endif	// SVEC_H
