// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <qfontmet.h>
#include <qpainter.h>
#include "Canvas.h"
#include "PlainRenderer.h"
#include "PreformatRenderer.h"

PlainRenderer::PlainRenderer( Canvas*     canvas,
                              int         clipWidth,
                              QObject*    parent,
                              const char* name )
        : Renderer( canvas, clipWidth, parent, name ),
          _pre( 0 ),
          _done( FALSE )
{
//    browser->dtdSelected( "-//SMV//DTD PLAIN 1.0//EN" );
    styleSheetManager->request( this, "PLAIN", "-//SMV//DTD PLAIN 1.0//EN" );
}

PlainRenderer::~PlainRenderer()
{
    delete _pre;
}

void PlainRenderer::data( const char* bytes, int length )
{
    for ( int i = 0; i < length; i++ ) {
        _leftover += bytes[i];
    }
    
    if ( _pre ) {
        _pre->content( _leftover );
        _leftover.truncate( 0 );
    }
}

void PlainRenderer::endOfData()
{
    data( 0, 0 );
    if ( _pre ) {
        _pre->endOfData();
        canvas()->redraw();
    } else {
        _done = TRUE;
    }
}

void PlainRenderer::styleSheet( StyleSheet* styleSheet )
{
    if ( styleSheet ) {
        STag tag;
        tag.name = "PLAIN";

        Style* style = styleSheet->getStyle( 0, tag );

        QString tmpStr;
        QColor color( "black" );
        if ( style->stringValue( "color", tmpStr ) ) {
            color.setNamedColor( tmpStr );
        }

        int tmpInt;
        QFont::Weight weight;
        if ( ( style->enumValue( "font-weight", tmpInt ) ) && ( tmpInt == Style::Bold ) ) {
            weight = QFont::Bold;
        } else {
            weight = QFont::Normal;
        }
        
        QString fontFamily = "helvetica";
        style->listValue( "font-family", fontFamily );
        
        int fontSize = 12;
        style->numberValue( "font-size", fontSize );
        
        int fontStyle = Style::Normal;
        style->enumValue( "font-style", fontStyle );
        
        QFont font( fontFamily, fontSize, weight, fontStyle == Style::Italic );
        
        int textDecoration = Style::Normal;
        style->enumValue( "text-decoration", textDecoration );
        
        font.setUnderline( textDecoration == Style::Underline );
        QFontMetrics fm( font );

        StyleRenderer* s = new StyleRenderer( font, color, "", fm.width( ' ' ), fm.ascent(), canvas(), 0, this );
        s->resize( 0, 0 );
        
        _pre = new PreformatRenderer( canvas(), 0, clipWidth(), this );
        connect( _pre, SIGNAL( resized() ), this, SLOT( childSizeChanged() ) );
        _pre->move( 0, 0 );
        _pre->_renderers.append( s );
        data( 0, 0 );
        if ( _done ) {
            endOfData();
        }
    }
}

bool PlainRenderer::redraw()
{
    if ( _pre ) {
        _pre->widthChanged( clipWidth() );
        if ( _pre->redraw() ) {
            resize( _pre->width(), _pre->height() );
            _needRedraw = FALSE;
            return TRUE;
        }
    }

    _needRedraw = FALSE;

    return FALSE;
}

void PlainRenderer::repaint( QPainter& p, const Rect& r )
{
    p.translate( x(), y() );
    
    if ( _pre ) {
        _pre->repaint( p, r );
    }

    p.translate( -x(), -y() );
}
