#ifndef _ScrolledWindow_h_
#define _ScrolledWindow_h_

#include <qwidget.h>

class QScrollBar;

class ScrolledWindow : public QWidget {
    Q_OBJECT
    QScrollBar* _hsb;
    QScrollBar* _vsb;
    QWidget*    _clip;
    QWidget*    _window;
protected:
    virtual void resizeEvent( QResizeEvent* e );

    virtual void keyPressEvent( QKeyEvent* e );
public:
    ScrolledWindow( QWidget* parent=0, const char* name=0 );

    virtual ~ScrolledWindow();

    QWidget* clip();

    void setWindow( QWidget* window );
public slots:
    void hsbMoved( int value );

    void vsbMoved( int value );

    void windowResized();

    void scrollUp();

    void scrollDown();

    void scrollLeft();

    void scrollRight();

    void scrollPrior();

    void scrollNext();
};

#endif
