#ifndef __DIALOGS_H__
#define __DIALOGS_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: dialogs.h,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: dialogs.h,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.2  1997/04/06 21:34:09  ruben
 * removed RenameDialog
 * reworked mountentry list to a Qt based one (templates)
 * reworked char* signals to const char* ones
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#include <qwindow.h>
#include <qdialog.h>
#include <qpainter.h>
#include <qframe.h>
#include <qdrawutl.h>
#include <qpushbt.h>
#include <qmlined.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qpopmenu.h>
#include <qcombo.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <qmsgbox.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "data_tree.h"
#include "fpropdlg.h"
#include "file_tool.h"

// must be last
#include "vars.h"

//>------------------------------------

class   ConfigDialog:public QTabDialog
{
	public:

	ConfigDialog(QWidget * parent, const char *name);

};

//>------------------------------------

class   HelpFrame:public QMultiLineEdit
{

	public:

	HelpFrame(QWidget * parent, const char *name);

};

//>------------------------------------

class DfDialog : public QDialog
{
  public:

   DfDialog (QWidget * parent, const char *name);
};

//>------------------------------------

class   AboutFrame:public QFrame
{
	Q_OBJECT

     public:

	AboutFrame(QWidget * parent, const char *name);

     public  slots:

	void    close_dialog();
};

class LinkFrame:public QFrame
{
	Q_OBJECT
	
    private:
    
        QRadioButton *hardlink;
        QRadioButton *softlink;
    
        QLineEdit *target_label2;
        char *source_name;
            
    public:

	LinkFrame (QWidget * parent, const char *name,char *temp_name);

    public slots:

        void do_link ();	
        void close_dialog ();
};

//>------------------------------------

class   ObjectFrame:public QFrame
{
	Q_OBJECT

	protected:

	void    paintEvent(QPaintEvent *);

	        private:

	char   *frame_text;
	char   *old_frame_text;

	public:

	ObjectFrame(QWidget *, const char *);
	~ObjectFrame();

	public  slots:

	void    set_objects(int);
};

//>------------------------------------

class   DirectoryFrame:public QFrame
{
	Q_OBJECT

	protected:

	void    paintEvent(QPaintEvent *);

	private:

	char   *frame_text;
	char   *old_frame_text;

	public:

	DirectoryFrame(QWidget *, const char *);
	~DirectoryFrame();

	public  slots:

	void    set_text(const char *);
};

//>------------------------------------

class   FileFrame:public QFrame
{
	Q_OBJECT

	protected:

	void    paintEvent(QPaintEvent *);

	private:

	char   *frame_text;
	char   *old_frame_text;

	public:

	FileFrame(QWidget *, const char *);
	~FileFrame();

	public  slots:

	void    set_info(int, unsigned long);
};

//>-------- end of info labels

class   OptionsPopup:public QPopupMenu
{

	Q_OBJECT

    public:

	OptionsPopup(QWidget *, char *);
	void assign_node(FileTreeNode *, char *);
	void set_multiple_entries (char); 

    public  slots:

	void new_dir();
        void create_link();
	void delete_entry();        	
        void change_properties (const char *,const char *);
	void properties();

    private:

	FileTreeNode *node_used;
	char         *path_to_node;
	char         multiple_entries;
	
    signals:

        void update_widgets ();
        void emit_link         (char *);
        void emit_delete       (char *,FileTreeNode *);
        void emit_delete_nodes ();
        void emit_prop_change  (const char *,const char *,FileTreeNode *);
};

class   OperationPopup:public QPopupMenu
{

	Q_OBJECT

    public:

	OperationPopup   (QWidget *, char *);
	void assign_node (FileTreeNode *, char *);

    public slots:

	void cancel();
        void move_files(); 
        void copy_files();

    private:

	FileTreeNode *node_used;
	char *path_to_node;
	
    signals:

        void update_widgets ();
        
        void op_cancel (bool);
        void op_copy (bool);
        void op_move (bool);
};



//>--------- just a linked list



struct MountEntry
{
	QString *szTotal_path,
	       *szMount_device,
	       *szMount_point;

	MountEntry(const char *, const char *, const char *);
	MountEntry(const MountEntry&);

   ~MountEntry();
};

#if defined(DEFAULT_TEMPLATECLASS)
typedef QListT < MountEntry > MountListBase;
typedef QListIteratorT < MountEntry > MountListIterator;

#else
typedef Q_DECLARE(QListM, MountEntry) MountListBase;
typedef Q_DECLARE(QListIteratorM, MountEntry) MountListIterator;

#endif

class   MountList:public MountListBase
{
	int     compareItems(GCI item1, GCI item2);
	GCI     newItem(GCI item);
	void    deleteItem(GCI item);

	public:

	MountList();
};

//>--------- the mount combobox also encapsulates
// >--------- all mounting tools at this point

class   MountBox:public QComboBox
{
	Q_OBJECT

	private:

	MountList	spMountList;
	
	protected:

	bool  remove_item(const char*);	// give mountpoint, not device
	
	
	public:

	MountBox(QWidget * parent, const char *);

	void    add_item(char *, char *, char *);

	public  slots:

	void    choose_item(int);
	void    unmount();
	void	getMountedfss();

	signals:

	void    goto_mount_point(const char *);
};

//>------------------------------------

#endif	 // __DIALOGS_H__
