/*
 * $Id: date.c,v 1.8 1998/09/24 16:53:39 gregm Exp $
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Some generic date conversion type routines.
 */

#include "main.h"

/*
 * Function    : db_time_str
 * Description : This function will convert current time into a string 
 *               sutible for insertion into a database.
 * Arguments   : buf    -- A pre-aloocated buffer for the result.
 *               buflen -- The size of the buffer.
 */ 
char *
db_time_str (char *buf, int buflen)
{
  struct tm     *tim;
  time_t        gm_time;
  
  g_return_val_if_fail (buf != NULL, NULL);

  gm_time = time (NULL);
  tim     = localtime (&gm_time);
  strftime (buf, buflen, "%Y-%m-%d:%H:%M:%S", tim);
  printf(buf);
  return buf;
}

/* EOF */







