/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 */

/*--------------------------------------------------------------------------*/

#ifndef SEEK_SET
#define	SEEK_SET	0				/* Seek from beginning of file.			*/
#define	SEEK_CUR	1				/* Seek from current position.			*/
#define	SEEK_END	2				/* Seek from end of file.				*/
#endif

#ifndef NULL
#define	NULL		((void *)0)
#endif

/*--------------------------------------------------------------------------*/
/* Prototypes for utility functions
 */

void loader_init (unsigned long arg);
void mem_clear (void *mem,unsigned long count);
void mem_move (void *dest,const void *srce,unsigned long count);
int mem_cmp (void *mem1,void *mem2,unsigned long count);
void Printf (const char *fmt,...);
void put_str (const char *str);
void put_char (const int c);
int get_char (unsigned long timeout);
unsigned long get_time(void);
void panic (const char *fmt,...);
int file_size (const char *path);
int file_open (const char *path);
int file_seek (int where,int whence);
long file_tell (void);
int file_read (char *buf,int count);
void file_close (void);
unsigned long get_compat_booti_version (void);
unsigned long get_booti_version (void);
unsigned long get_compat_machtype (void);
unsigned long get_machtype (void);
int can_do_symbols(void);
void clear_symbols (void);
int add_symbol (char *data);
void * get_startcode_entry (void);
void print_model (int cpu, int hasfpu);

void mem_alloc_init (void *heap_base,unsigned long heap_size);
void * mem_alloc (unsigned long size);
unsigned long mem_maxalloc(void);
int mem_resize(void *memaddr, unsigned long newsize);
int mem_free (void *memaddr);
int str_len (const char *s);
void str_cpy (char *d,const char *s);
void str_cat (char *d,const char *s);
void str_ncat (char *d,const char *s,unsigned long n);
void str_ncpy (char *d,const char *s,unsigned long n);
int prefix_string (const char *s,const char *p);
int equal_strings (const char *s1,const char *s2);
int case_equal_strings (const char *s1,const char *s2);
unsigned long enable_icache (void);
unsigned long disable_icache (void);
void invalidate_icache (void);
void percent_init (unsigned long total);
void percent_term (const char *msg);
void percent_show (unsigned long current);

/*-----------------------------< end of file >------------------------------*/
