/*
 * Wine specific enhancements to c2man
 *
 * Copyright 1998 Douglas Ridgway
 *
 */

#include <stdio.h>
#include <string.h>
#include "wine_spec.h"

#define BUFFER_SIZE 1024

#define WHITESPACE " \t\v\n\f\r"

#define MAXFUNCS 4096
#define MAXLEN 128

char functiontable[MAXFUNCS*2][MAXLEN];
int maxfunc=0;
int usespecfile=0;

#define REWRITE_PER_SPEC

/*
 * Checks to see if a function should be documented
 */
int document_function(Declarator *declarator) {
  int i=0;
  if (!usespecfile) return 1;
  while(functiontable[i][0] != '\0') {
    if(strcmp(functiontable[i+1], declarator->name)==0) {
#ifdef REWRITE_PER_SPEC
      if (!declarator->outputname) {
	declarator->outputname = functiontable[i];
#ifdef DEBUGGING
	fprintf(stderr, "Created new outputname %s for %s\n", 
		declarator->outputname, declarator->name);
#endif
      } else {
	fprintf(stderr, "Double rewrite! %s == %s?\n", declarator->outputname, functiontable[i]);
      }
#endif
      return 1;
    }
    i += 2;
  }
  return 0;
}

void parse_spec(char *path) {
  char buf[BUFFER_SIZE];
  FILE *sf = fopen(path, "r");

  usespecfile = 1;
  while (1) {
    char *s = NULL, *t=NULL, *s2=NULL;
    int len=0;
    if (!fgets(buf, BUFFER_SIZE, sf)) {
      if (feof(sf)) {
	break;
      } else {
	perror(" while reading spec file");
	exit(1);
      }
    }
    s = strstr(buf, "stdcall");
    if (!s) continue;
    s +=7;
    s += strspn(s, WHITESPACE);
    t = strchr(s, '(');
    if (!t) {
      fprintf(stderr, "bad t! : buf is %s\n", buf); 
      exit(1);
    }
    s2 = strchr(t, ')');
    if (!s2) {
      fprintf(stderr, "bad s2! : buf is %s\n", buf); 
      exit(1);
    }
    s2 +=2;
    *t = '\0';
    len = strcspn(s2, WHITESPACE);
    s2[len] = '\0';
    if (snprintf(functiontable[maxfunc], MAXLEN, "%s", s)==-1 ||
	snprintf(functiontable[maxfunc+1], MAXLEN, "%s", s2) == -1) {
      fprintf(stderr, "Function name too long! Increase MAXLEN or write a better implementation!\n");
      exit(1);
    }
    maxfunc += 2;
    if (maxfunc>MAXFUNCS) {
      fprintf(stderr, "Too many functions! Increase MAXFUNCS or write a better implementation!\n");
      exit(1);
    }
  }
}

