// $Id: box.cc,v 1.19 1998/09/24 13:19:43 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Box::Include(File &f,const Widget &w)
{  f.include("gtk--/box.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Box::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,w.Class()[3]=='H' ?"Gtk_HBox":"Gtk_VBox");
}

void Gtk_Box::Derive(File &f,const Widget &w)
{  f << (w.Class()[3]=='H' ?"Gtk_HBox":"Gtk_VBox");
}

static const bool homo_def=false;
static const int spac_def=0;

void Gtk_Box::Construct(File &f,const Widget &w,bool is_member)
{  bool homogeneous=w.getBool("homogeneous",homo_def);
   int spacing=w.getInt("spacing",spac_def);
   
   f << StandardWriter::ConstructName(f,w,is_member,
   			(w.Class()[3]=='H' ?"Gtk_HBox":"Gtk_VBox"));
   f << "(" << (homogeneous?"true":"false") << ", " << spacing << ")";
}

bool Gtk_Box::NeedConstruct(const Widget &w,bool is_member)
{  bool homogeneous=w.getBool("homogeneous",homo_def);
   int spacing=w.getInt("spacing",spac_def);
   return homogeneous!=homo_def || spacing!=spac_def;
}

void Gtk_Box::PackChild(File &f,const Widget &w,const string instance)
{  if (w.Class()=="Placeholder") return; // dirty hack
   const Widget &ch=w.get_Child_params();
   bool pack_end=(ch.getString("pack","GTK_PACK_START"))=="GTK_PACK_END";
   bool expand=ch.getBool("expand",true);
   bool fill=ch.getBool("fill",true);
   int padding=ch.getInt("padding",0);
   if (expand && fill && !padding)
      f << instance << (pack_end?"pack_end_defaults":"pack_start_defaults") 
        << "(" << f.Pointer(w) << ");\n\t";
   else
      f << instance << (pack_end?"pack_end":"pack_start") 
        << "(" << f.Pointer(w) << ", " 
        << (expand?"true":"false") << ", " << (fill?"true":"false") << ", "
        << padding << ");\n\t";
}

void Gtk_Box::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      PackChild(f,*i,instance);
}
