/* 
   GCGenericRecord.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: January 1997

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __GCGenericRecord_h__
#define __GCGenericRecord_h__

#include <extensions/GCObject.h>

@class NSArray;
@class NSMutableArray;
@class NSDictionary;
@class NSMutableDictionary;
@class NSString;
@class NSData;
@class GCMutableDictionary;

@class EOEntity;

@interface GCGenericRecord : GCObject
{
    EOEntity* entity;
    GCMutableDictionary* values;
}

/* Initializing new instances */
- initWithPrimaryKey:(NSDictionary*)aKey entity:(EOEntity*)anEntity;

/* Getting the associated entity */
- (EOEntity*)entity;

/* Key-value coding methods */
- (BOOL)takeValuesFromDictionary:(NSDictionary*)dictionary;
- (NSDictionary*)valuesForKeys:(NSArray*)keys;

/* Shortcuts to key-value coding methods */
- (void)setObject:anObject forKey:aKey;
- objectForKey:aKey;
- (void)removeObjectForKey:aKey;

@end /* GCGenericRecord */

#endif /* __GCGenericRecord_h__ */
