/* 
   SQLServerSQLExpression.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Author: Scott Christley <scottc@net-community.com>
   Date: October 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <Foundation/NSUtilities.h>

#include <eoaccess/EOEntity.h>
#include <eoaccess/EORelationship.h>

#include "SQLServerSQLExpression.h"

@implementation SQLServerSQLExpression

+ (Class)selectExpressionClass { return [SQLServerSelectSQLExpression class]; }

@end /* SQLServerSQLExpression */


@implementation SQLServerSelectSQLExpression

- selectExpressionForAttributes:(NSArray*)attributes
  lock:(BOOL)flag
  qualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder
  channel:(EOAdaptorChannel*)channel
{
    lock = flag;
    [super selectExpressionForAttributes:attributes
	   lock:flag
	   qualifier:qualifier
	   fetchOrder:fetchOrder
	   channel:channel];
    return self;
}

- (NSString*)fromClause
{
    NSMutableString* fromClause
	    = [NSMutableString stringWithCString:"\nFROM "];
    NSEnumerator* enumerator = [fromListEntities objectEnumerator];
    BOOL first = YES;
    id key;

    /* Compute the FROM list from all the aliases found in
       entitiesAndPropertiesAliases dictionary. Note that this dictionary
       contains entities and relationships. The last ones are there for
       flattened attributes over reflexive relationships. */
    while((key = [enumerator nextObject])) {
	if(first)
	    first = NO;
	else
	    [fromClause appendString:@", "];

	if([key isKindOfClass:[EORelationship class]]) {
	    /* This key corresponds to a flattened attribute. */
	    [fromClause appendFormat:@"%@ %@",
			    [[key destinationEntity] externalName],
			    [entitiesAndPropertiesAliases objectForKey:key]];
	    if (lock)
		[fromClause appendString:@" HOLDLOCK"];
	}
	else {
	    /* This is an EOEntity. */
	    [fromClause appendFormat:@"%@ %@",
			    [key externalName],
			    [entitiesAndPropertiesAliases objectForKey:key]];
	    if (lock)
		[fromClause appendString:@" HOLDLOCK"];
	}
    }

    return fromClause;
}

@end /* SQLServerSelectSQLExpression */
