#ifndef lint
static char *RCSid = "$Id: tracing.c,v 1.9 1993/05/10 05:49:42 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "rexx.h"
#include <stdio.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <ctype.h>
#ifdef HAVE_ASSERT_H
# include <assert.h>
#endif
#include <string.h>

static int traceflag = 0 ;
static int lasttracedline = -1 ;   
static int ctrlcounter = 0 ;
static int notnow = 0 ;

static char tracestr[LINELENGTH+1] ;


extern sysinfo systeminfo ;

int pushcallstack( treenode *this )
{
   nodeptr *tmpptr=NULL ;
   extern sysinfo systeminfo ;
   
   if (systeminfo->cstackcnt >= systeminfo->cstackmax)
   {
      assert( systeminfo->cstackcnt == systeminfo->cstackmax ) ;
      tmpptr = Malloc( (systeminfo->cstackmax*2+10)*sizeof(nodeptr)) ;
      if (systeminfo->callstack)
      {
         memcpy( tmpptr, systeminfo->callstack, 
                                 systeminfo->cstackcnt*sizeof(nodeptr) ) ;
         Free( systeminfo->callstack ) ;
      }
      systeminfo->callstack = tmpptr ;
      systeminfo->cstackmax *= 2 ;
      systeminfo->cstackmax += 10 ;
   }

   ctrlcounter++ ;      
   systeminfo->callstack[systeminfo->cstackcnt++] = this ;
   return systeminfo->cstackcnt ;
}


void popcallstack( int value )
{
   extern sysinfo systeminfo ;

   if (value>=0)
   {
      assert( systeminfo->cstackcnt >= value ) ;
      ctrlcounter -= systeminfo->cstackcnt - value ;
      systeminfo->cstackcnt = value ;
   }

   ctrlcounter-- ;
   --(systeminfo->cstackcnt) ;

   assert( systeminfo->cstackcnt >= 0 ) ;
   assert( ctrlcounter >= 0 ) ;
}


void printout( streng *message ) 
{
   int rc=0 ;

   rc = HOOK_GO_ON ;
   if (systeminfo->hooks & HOOK_MASK(HOOK_STDERR))
      rc = hookup( HOOK_STDERR, message ) ;

   if (rc==HOOK_GO_ON)
   {
      if ( get_options_flag( currlevel, EXT_STDOUT_FOR_STDERR ) )
      {
         write( fileno(stdout), message->value, message->len ) ;
         putc( 0x0a, stdout ) ;
         fflush( stdout ) ;
      }
      else
      {
         write( fileno(stderr), message->value, message->len ) ;
         putc( 0x0a, stderr ) ;
      }
   }
}




void traceerror( treenode *this, int RC )
{
   streng *message=NULL ;

   if (trace_stat=='N') 
      traceline(this, 'C', 0) ; 

   if (trace_stat!='O')
   {
      message = Str_make( 20+sizeof(int)*3 ) ;
      sprintf(message->value, "       +++ RC=%d +++",RC) ; 
      message->len = strlen( message->value ) ;

      printout( message ) ;
      Free_string( message ) ;
   }
}


void tracecompound( streng *stem, int length, streng *index, char trch )
{
   streng *message=NULL ;
  
   if ((traceflag)||(trace_stat!='I'))
      return ;
   
   /* bja - remove Str_ify() 
     stem = Str_ify(Str_dup(stem)) ;
     index = Str_ify(Str_dup(index)) ;
   */

   message = Str_make( stem->len + index->len + 30 + ctrlcounter ) ;

   sprintf(tracestr,"       >%c> %%%ds  \"%%.%ds.%%.%ds\"",trch,
                                        ctrlcounter,length, index->len) ;
   sprintf(message->value, tracestr,"",stem->value,index->value ) ; 

   message->len = strlen( message->value ) ;
   printout( message ) ;

   Free_string( message ) ;
   /* bja - remove Str_ify()
     Free_string( stem ) ;
     Free_string( index ) ;
   */
}


void starttrace( void ) 
{
   traceflag = 0;
   notnow = 1 ;
}

void tracemsg( void )
{
   streng *message=NULL ;
   int rc=0 ;
   char *msg= "       +++ Interactive trace. TRACE OFF to end debug, ENTER to continue. +++" ;

   rc = HOOK_GO_ON ;
   message = Str_cre( msg ) ;
   printout( message ) ;
   Free_string( message ) ;
}


int intertrace( void )
{
   streng *str=NULL ;
   int retvalue=0, rc=0 ;
  
   if (traceflag)
      return 0 ;

   if (notnow==1) 
   {
      notnow = 2 ;
      return 0 ; 
   }
   else if (notnow==2) 
   {
      notnow = 0 ;
      tracemsg() ; 
   }

   traceflag = 1 ;
   retvalue = (-1) ;
   for (; retvalue<0; ) {
      rc = HOOK_GO_ON ;
      if (systeminfo->hooks & HOOK_MASK(HOOK_TRCIN))
         rc = hookup( HOOK_TRCIN, &str ) ;

      if (rc==HOOK_GO_ON)
         str = readkbdline() ;

      if (str->len==0) 
      {
         traceflag = 0 ;
         retvalue = 0 ;
      }

      if ((Str_len(str)==1)&&(str->value[0]=='='))
      {
         traceflag = 0 ;
         retvalue = 1 ;
      }
      else if (str->len)
      {
         dointerpret( str ) ; 
         if (!systeminfo->interactive)
            return 0 ;
      }
   }

   return retvalue ;
}


void tracenumber( num_descr *num, char type ) 
{
   extern proclevel currlevel ;
   char tmpch=' ' ;
   streng *message=NULL, *tmpstr=NULL ;
   
   if (traceflag)
      return ;

   tmpch = currlevel->tracestat ;
   if ((tmpch=='I')||((tmpch=='R')&&(type!='.')))
   {
      tmpstr = str_norm( num, NULL ) ;
      message = Str_make( 30 + ctrlcounter + tmpstr->len ) ;
      sprintf(tracestr,"       >%%c> %%%ds  \"%%.%ds\"",ctrlcounter,tmpstr->len) ; /* bja */
      sprintf(message->value,tracestr,type,"", tmpstr->value) ; /* bja */
      message->len = strlen( message->value ) ;
      printout( message ) ;
      Free_string( message ) ;
      Free_string( tmpstr ) ;
   }
}


void tracebool( int value, char type ) 
{
   char tmpch=' ' ;
   extern proclevel currlevel ;
   streng *message=NULL ;

   if (traceflag)
      return ;

   tmpch = currlevel->tracestat ;
   if ((tmpch=='I') || ((tmpch=='R') && (type!='.')))
   {
      message = Str_make( 35 + ctrlcounter ) ;
      sprintf(tracestr,"       >%%c> %%%ds  \"%%d\"",ctrlcounter ) ;
      sprintf(message->value,tracestr,type,"",value) ;
      message->len = strlen( message->value ) ;
      printout( message ) ;
      Free_string( message ) ;
   }
}


void tracevalue( streng *str, char type )
{
   extern proclevel currlevel ;
/*   extern char tracestr[] ; */
   char tmpch=' ' ;
   streng *message=NULL ;

   if (traceflag)
      return ;

   tmpch = currlevel->tracestat ;
   if ((tmpch=='I')||((tmpch=='R')&&(type!='.'))) 
   {
      message = Str_make( str->len + 30 + ctrlcounter ) ;
      sprintf(tracestr,"       >%%c> %%%ds  \"%%.%ds\"",ctrlcounter, str->len) ; /* bja */
      sprintf(message->value,tracestr,type,"", str->value) ; /* bja */
      message->len = strlen( message->value ) ;
      printout( message ) ;
      Free_string( message ) ;
   }
}



void traceline( treenode *this, char tch, int offset ) 
{
   streng *srcstr=NULL ;
   extern sysinfo systeminfo ;
   
   if ((tch=='O')||(traceflag))
      return ; 

   if ((this->charnr<0)||(this->lineno<0)) 
      return ;

   if ((tch=='I')||(tch=='R')||(tch=='A')) goto trace ;
   if ((tch=='L')&&(this->type==X_LABEL)) goto trace ;
   if (tch=='C')
      if ((this->type==X_COMMAND) || 
          ((this->type==X_ADDR_N) && (this->p[0])))
         goto trace ;

   return ;

trace: {
       streng *message ;
       srcstr = getsourceline(this->lineno,this->charnr,
                      systeminfo->firstline, systeminfo->lastline) ; 

       message = Str_make( ctrlcounter+20+srcstr->len+offset ) ;
       if (this->lineno==lasttracedline) {
          sprintf(tracestr,"       *-* %%%ds%%.%ds",ctrlcounter+offset,srcstr->len) ; /* bja */
          sprintf(message->value,tracestr,"", srcstr->value) ; } /* bja */
       else {
          sprintf(tracestr,"%%6d *-* %%%ds%%.%ds",ctrlcounter+offset, srcstr->len) ; /* bja */
          sprintf(message->value,tracestr,this->lineno,"", srcstr->value) ; } /* bja */

       message->len = strlen( message->value ) ;
       printout( message ) ;
       lasttracedline = this->lineno ;
       Free_string( message ) ;
       Free_string( srcstr ) ; }
}

/*
char *formatstring( int level, int lineno, char around, char middle ) 
{
   char *ptr=NULL ;

   if (lineno>0)
   {
      *(ptr++)='%' ;
      *(ptr++)='6' ;
      *(ptr++)='d' ;
   }
   else
   {
      memset( ptr, ' ', 6 ) ;
      ptr += 6 ;
   }

   *(ptr++) = ' ' ;
   *(ptr++) = around ;
   *(ptr++) = middle ;
   *(ptr++) = around ;
   *(ptr++) = ' ' ;
      
#if OLD_OPTIONS
   if (level>12 && currlevel->options.prune_trace)
#else
   if ( level > 12 
   && get_options_flag( currlevel, EXT_PRUNE_TRACE ) )
#endif
   {
      memcpy( ptr, "[...] ", 6 ) ;
      ptr += 6 ;
      memset( ptr, ' ', 30 ) ;
      ptr += 30 ;
   }
   else
   {
      memset( ptr, '
   }


      sprintf(fmt,"%%6d %c%c%c [...] %%%ds%%s", around, middle, around, 30 ) ;
   else
      sprintf(fmt,"%%6d %c%c%c %%%ds%%s", around, middle, around, level*3 ) ;
}
*/



void traceback( void )
{
   extern nodeptr currentnode /*, callstack[] */ ;
   static char fmt[20] ;
   extern sysinfo systeminfo ;
   sysinfo ss ;
   streng *message=NULL ;
   nodeptr ptr=NULL ;
   int i=0, j=0 ;

   message = Str_make( 512 + ctrlcounter ) ;
   if (currentnode)
   {
      sprintf(fmt,"%%6d +++ %%%ds%%s", ctrlcounter*3 ) ;
      sprintf(message->value,fmt,currentnode->lineno,"",
              getsourceline(currentnode->lineno,
              currentnode->charnr, systeminfo->firstline,
              systeminfo->lastline)->value) ; /* bja */
      message->len = strlen( message->value ) ;
      printout( message ) ;
   }
   
   j = ctrlcounter ;
   for (ss=systeminfo; ss; ss=ss->previous ) 
   {
      for (i=ss->cstackcnt-1;i>=0;i--) 
      {
         ptr = ss->callstack[i] ;
         if (!ptr)
            continue ;
#if OLD_OPTIONS
         if (--j>12 && currlevel->u.options.prune_trace)
#else
         if ( -- j > 12 
         && get_options_flag( currlevel, EXT_PRUNE_TRACE ) )
#endif
            sprintf(fmt,"%%6d +++ [...] %%%ds%%s", 30 ) ;
         else
            sprintf(fmt,"%%6d +++ %%%ds%%s", (j)*3 ) ;

         sprintf(message->value,fmt,ptr->lineno,"",
                 getsourceline(ptr->lineno,ptr->charnr,
                 ss->firstline, ss->lastline)->value) ; /* bja */

         message->len = strlen( message->value ) ;
         printout( message ) ;
      } 
   }
   Free_string( message ) ;
}


static char buf[32] ;
static int bufptr=0 ;

void queue_trace_char( char ch )
{
   if (bufptr<32)
      buf[bufptr++]=ch ;
   else
       exiterror( ERR_INTERPRETER_FAILURE, 0 )  ;
}


void flush_trace_chars( void )
{
   int cnt=0 ;

   for (cnt=0; cnt<bufptr; cnt++)
      set_trace_char( buf[cnt] ) ;

   bufptr = 0 ;
}


void set_trace_char( char ch )
{
   extern sysinfo systeminfo ;
   extern proclevel currlevel ;
 
   switch (ch=toupper(ch))
   {
      case '?':
         ch = systeminfo->interactive = !systeminfo->interactive ;
         if (ch)
            starttrace() ;
         break ;         

      case 'F':
         ch = 'N' ;

      case 'A':
      case 'C':
      case 'E':
      case 'I':
      case 'L':
      case 'N':
      case 'O':
      case 'R':
      case 'S':
         currlevel->tracestat=ch ;
         break ;

      default:
          exiterror( ERR_INVALID_TRACE, 1, "?ACEFILNORS", ch )  ;
   }

   if (ch=='O')
      systeminfo->interactive = 0 ;
   trace_stat = currlevel->tracestat ;
}



void set_trace( streng *setting )
{
   int cptr=0 ;

   if (myisnumber(setting))
      if (myiswnumber(setting))
         return ;  /* need to do something else ... */
      else
          exiterror( ERR_INVALID_INTEGER, 0 )  ;

   for (cptr=0; cptr<Str_len(setting); cptr++)
   {
      set_trace_char( setting->value[cptr] ) ;
      if (isalpha( setting->value[cptr])) 
         return ;
   }
}


