/*    con_i18n.cpp
 *
 *    I18N support by kabi@fi.muni.cz
 */
#include <string.h>
#include <assert.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#if defined(AIX)
#include <sys/select.h>
#endif
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <locale.h>
#include "con_i18n.h"

#ifdef USE_HARD_REMAP

/*
 * This part was used for the very first time
 * but it's a dirty hack so it is not being
 * used any more.
 *
 * But as it took me few hours to write even this
 * version I'll leave it here as example.
 */

static struct Tczkey {
    KeySym key_english;
    KeySym key_czech;
} czech_key[] = {
    { 0,}, /* we don't want czech keyboard */
    {0xff & '`',0xff & '`'},
    {0xff & '1',0xff & '+'},
    {0xff & '2',0xff & ''},
    {0xff & '3',0xff & ''},
    {0xff & '4',0xff & ''},
    {0xff & '5',0xff & ''},
    {0xff & '6',0xff & ''},
    {0xff & '7',0xff & ''},
    {0xff & '8',0xff & ''},
    {0xff & '9',0xff & ''},
    {0xff & '0',0xff & ''},
    {0xff & '-',0xff & '='},
    {0xff & '~',0xff & '~'},
    {0xff & '!',0xff & '1'},
    {0xff & '@',0xff & '2'},
    {0xff & '#',0xff & '3'},
    {0xff & '$',0xff & '4'},
    {0xff & '%',0xff & '5'},
    {0xff & '^',0xff & '6'},
    {0xff & '&',0xff & '7'},
    {0xff & '*',0xff & '8'},
    {0xff & '(',0xff & '9'},
    {0xff & ')',0xff & '0'},
    {0xff & '-',0xff & '%'},

    {0xff & '[',0xff & ''},
    {0xff & ']',0xff & ')'},
    {0xff & '\\',0xff & '\\'},
    {0xff & '{',0xff & '/'},
    {0xff & '}',0xff & '('},
    {0xff & '|',0xff & '|'},

    {0xff & ';',0xff & ''},
    {0xff & '\'',0xff & ''},
    {0xff & ':',0xff & '"'},
    {0xff & '"',0xff & '!'},

    {0xff & ',',0xff & ','},
    {0xff & '.',0xff & '.'},
    {0xff & '/',0xff & '-'},
    {0xff & '<',0xff & '?'},
    {0xff & '>',0xff & ':'},
    {0xff & '/',0xff & '_'},
    { 0,}
} ;

static struct Tczkey key_acute[] = {
    {0xff & 'e',0xff & ''},
    {0xff & 'E',0xff & ''},
    {0xff & 'r',0xff & ''},
    {0xff & 'R',0xff & ''},
    {0xff & 'y',0xff & ''},
    {0xff & 'Y',0xff & ''},
    {0xff & 'u',0xff & ''},
    {0xff & 'U',0xff & ''},
    {0xff & 'i',0xff & ''},
    {0xff & 'I',0xff & ''},
    {0xff & 'o',0xff & ''},
    {0xff & 'O',0xff & ''},

    {0xff & 'a',0xff & ''},
    {0xff & 'A',0xff & ''},
    {0xff & 's',0xff & ''},
    {0xff & 'S',0xff & ''},
    {0xff & 'l',0xff & ''},
    {0xff & 'L',0xff & ''},

    {0xff & 'z',0xff & ''},
    {0xff & 'Z',0xff & ''},
    {0xff & 'c',0xff & ''},
    {0xff & 'C',0xff & ''},
    {0xff & 'n',0xff & ''},
    {0xff & 'N',0xff & ''},
    
    { XK_dead_acute,0xff & ''},
    
    { 0,}
};

static struct Tczkey key_caron[] = {
    {0xff & 'e',0xff & ''},
    {0xff & 'E',0xff & ''},
    {0xff & 'r',0xff & ''},
    {0xff & 'R',0xff & ''},
    {0xff & 't',0xff & ''},
    {0xff & 'T',0xff & ''},
    {0xff & 'u',0xff & ''},
    {0xff & 'U',0xff & ''},
    {0xff & 'o',0xff & ''},
    {0xff & 'O',0xff & ''},

    {0xff & 's',0xff & ''},
    {0xff & 'S',0xff & ''},
    {0xff & 'd',0xff & ''},
    {0xff & 'D',0xff & ''},
    {0xff & 'l',0xff & ''},
    {0xff & 'L',0xff & ''},

    {0xff & 'z',0xff & ''},
    {0xff & 'Z',0xff & ''},
    {0xff & 'c',0xff & ''},
    {0xff & 'C',0xff & ''},
    {0xff & 'n',0xff & ''},
    {0xff & 'N',0xff & ''},

    { XK_dead_caron,0xff & ''},
    
    { 0,}
} ;

static struct TKeyboard {
    Tczkey *tab;
    KeySym deadkey;
    int next;
} str_keyboard[] = {
    { czech_key, 0, 0 },
    { czech_key, XK_dead_acute, 3 },
    { czech_key, XK_dead_caron, 4 },
    { key_acute, 0, 0},
    { key_caron, 0, 0},
    { NULL,}
};

int KeyAnalyze(int e, int state, KeySym *keyori, KeySym *keyori1)
{
    static int oldstate = 0, keypos = 0;
    KeySym key = *keyori, pom;
    int i;

    /* find the state of keyboard */
    i = (state & (1L<<13));
     if (oldstate != i) {
	keypos = 0;
	oldstate = i;
    }

    if (!i)
	return 1;   // no action - normal US keyboard

/* Check for already remapped ISO8859-2 keys by Xserver*/
    if (key > 256 && key < 512) {
	key -= 256;
    } else {

/* We are on Czech keyboard */
/* check for dead key/switch */

	if (e) {
	    i = 0;
	    while(str_keyboard[i].tab != NULL) {
		if (str_keyboard[i].deadkey > 0 &&
		    str_keyboard[i].deadkey == key) {
		    keypos = str_keyboard[i].next;
		    return 0;   // it is a dead key
		}
		i++;
	    }
	} else if (keypos)
	    return 0;  // ignore key release its deadkey

	// printf("** Actual %d  %d %c %ld\n", keypos, e, key, key);
    
/* Ok, now check for remapping */
	i = 0;
	while(0 != (pom=str_keyboard[keypos].tab[i].key_english)) {
	    if (key == pom) {
		key = str_keyboard[keypos].tab[i].key_czech;
		break;
	    }
	    i++;
	}
	keypos = str_keyboard[keypos].next;
    }
    *keyori = key;
    *keyori1 = key;
    return 1;
}

#else

/*********************************************
 *                                           *
 *     Standart method for reading Keyboard  *
 *                                           *
 *********************************************/

/* ISO-8859-2 key-change
 *
 * All these functions are for keyboard reading.
 * Correct displaing of this text is another thing,
 * but as I only need ISO-8859 encoding support,
 * I don't care about this (for now).
 */
void I18NKeyAnalyze(KeySym *key, char *keyName)
{
    KeySym t = (unsigned char) keyName[0];
    /*
     * ISO-8859-2 is using some characters from 8859-1 and
     * rest of them is located between 0x100 - 0x200 in 'X' so
     * with ISO-8859-2 font we'll remap them down bellow < 0x100
     * This is mostly true for all Latin-X alphas, just
     * special font to display them correctly is needed.
     * This jobs does Xserver - and keysymbol is returned
     * in the 1st. byte of keyName string.
     */
    if (*key < 0xfd00)
	*key = t;
#ifdef HackForBadXserver
    /*
     * this is really hack - but some Xservers are somewhat
     * strange, so we remap character manually
     */ 
     if (*key > 256 && *key < 0xc00)
	*key &= 0xff;                              	
#endif	
}

/*
 * Initialize I18N functions - took me hours to
 * figure out how this works even though it was
 * cut & pasted from 'xterm' sources, but as 'xterm'
 * is using Xt Toolkit some things must be made
 * in different way
 */
XIC I18NInit(Display *display, Window win, unsigned long *mask)
{
    XIC xic = (XIC) NULL;
#if XlibSpecificationRelease >= 6
    int	i;
    char *s, *ns, *end, tmp[1024];
    XIM	xim = (XIM) NULL;
    XIMStyles *xim_styles;
    XIMStyle input_style = 0;
    int found;

    /* Locale setting taken from XtSetLanguageProc */

    /* note: "" is very important here !!! */
    if (! setlocale(LC_ALL, ""))
    	fprintf(stderr, "I18N: locale not supported by C library, locale unchanged");

    if (! XSupportsLocale()) {
        fprintf(stderr, "I18N: locale not supported by Xlib, locale set to C\n");
	setlocale(LC_ALL, "C");
    }

    if (! XSetLocaleModifiers(""))
        fprintf(stderr, "I18N: X locale modifiers not supported, using default\n");

    if (!(xim = XOpenIM(display, NULL, NULL, NULL))) {
	fprintf(stderr, "I18N: Failed to open input method\n");
	return xic;
    }

    if (XGetIMValues(xim, XNQueryInputStyle, &xim_styles, NULL)
        || !xim_styles) {
	fprintf(stderr, "I18N: Input method doesn't support any style\n");
        XCloseIM(xim);
        return xic;
    }

//    fprintf(stderr, "Locale of IM %s\n", XLocaleOfIM(xim));

    /*
     * This part is cut&paste from other sources
     * There is no reason to do it this way, because
     * the only input style currently supported is Root
     * but for the future extension I'll leave it here
     */
    found = False;
    strcpy(tmp, XIM_INPUT_STYLE); // Input Style */
    for(s = tmp; s && !found;) {
	while (*s && isspace(*s)) s++;
	if (!*s) break;
	if ((ns = end = strchr(s, ',')) != 0)
	    ns++;
	else
	    end = s + strlen(s);
	while (isspace(*end)) end--;
	*end = '\0';

	if (!strcmp(s, "OverTheSpot")) {
	    input_style = (XIMPreeditPosition | XIMStatusArea);
	} else if (!strcmp(s, "OffTheSpot")) {
	    input_style = (XIMPreeditArea | XIMStatusArea);
	} else if (!strcmp(s, "Root")) {
	    input_style = (XIMPreeditNothing | XIMStatusNothing);
	}
	for (i = 0; (unsigned short)i < xim_styles->count_styles; i++)
	    if (input_style == xim_styles->supported_styles[i]) {
		found = True;
		break;
	    }
	s = ns;
    }
    XFree(xim_styles);

    if (!found) {
	fprintf(stderr, "I18N: Input method doesn't support my preedit type\n");
	XCloseIM(xim);
	return xic;
    }

    /*
     * This program only understand the Root preedit_style yet
     */
    if (input_style != (XIMPreeditNothing | XIMStatusNothing)) {
	fprintf(stderr, "I18N: This program only supports the 'Root' preedit type\n");
	XCloseIM(xim);
        return xic;
    }

    xic = XCreateIC(xim, XNInputStyle, input_style,
                    XNClientWindow, win,
		    XNFocusWindow, win,
		    NULL);
    *mask = KeyPressMask;
    if (!xic) {
        fprintf(stderr, "I18N: Failed to create input context\n");
        XCloseIM(xim);
    } else if (XGetICValues(xic, XNFilterEvents, mask, NULL))
	fprintf(stderr, "I18N: Can't get Event Mask\n");
#endif
    return xic;
}

void I18NFocusIn(XIC xic)
{
#if XlibSpecificationRelease >= 6
    if (xic)
	XSetICFocus(xic);
#endif
}

void I18NFocusOut(XIC xic)
{
#if XlibSpecificationRelease >= 6
    if (xic)
        XUnsetICFocus(xic);
#endif
}

/*
 * Lookup correct keysymbol from keymap event
 */
int I18NLookupString(XKeyEvent *keyEvent, char *keyName, int keySize,
                      KeySym *key, XIC xic)
{
    int nbytes;
#if XlibSpecificationRelease >= 6
    if (xic) {
	Status status_return;
	/* no KeyRelease events here ! */
        nbytes = XmbLookupString(xic, keyEvent, keyName, keySize,
				 key, &status_return);
        /*
	if (nbytes)
	    printf("Keysbuffer %c\t0x%hx\t", keyName[0], (unsigned) keyName[0]);
	printf("Keys %d  0x%lx  '%s'\tStatus:%hx\n",
	       nbytes, *key, XKeysymToString(*key), status_return);
         */
    } else
#endif
    {
        static XComposeStatus compose_status = {NULL, 0};
        nbytes = XLookupString(keyEvent, keyName, keySize,
                               key, &compose_status);
    }
    return nbytes;
}
#endif
