/* (C) 1998 Patrick Lambert - http://devplanet.fastethernet.net */
/* Provided under the GPL (see www.gnu.org) */

#include "xproc.h"

#define VERSION "1.0"

char *lindex(char *input_string, int word_number)
{
 char *tokens[1024];
 static char tmpstring[1024];
 int i;
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while (((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 return(tokens[word_number]);
}

char *lrange(char *input_string, int starting_at)
{
 char *tokens[1024];
 static char tmpstring[1024]="";
 int i;
 char out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);
  strcpy(global_var,out_string);
  return (char *)global_var; }
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while(((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at)
 {
  return (char *)"";
 }
 while(tokens[starting_at] != NULL)
 {
  strncat(out_string,tokens[starting_at],1024);
  strcat(out_string, " ");
  starting_at++;
 }
 strncpy(global_var,out_string,511);
 return (char *)global_var;
}

int match(char *check,char *orig)
{
 while(*check == '*' || tolower(*check)==tolower(*orig) || *check == '?')
  if(*check == '*')
  if(*++check)
  {
   while(*orig)
    if(!match(check,orig++)) return 0;
   return 1;
  }
  else return 0;
  else if (!*check) return 0;
  else if (!*orig) return 1;
  else
  {
   ++check;
   ++orig;
  }
 return 1;
}

void CB_exit(GtkWidget *widget, GtkWidget *event)
{
 exit(0);
}

void CB_close(GtkWidget *widget, GtkWidget *event)
{
 gtk_widget_destroy (window2);
 window2 = NULL;
}

void CB_adv(GtkWidget *widget, GtkWidget *event)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Advanced");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, 150, 150);
 gtk_widget_set_usize (window2, 400, 300);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text2 = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text2, 0, 1, 0, 1);
 gtk_widget_show (text2);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text2)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text2));
 gtk_widget_realize (text2);
 gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, "Advanced information:\n\n", -1);

 gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, "Kernel log:\n\n", -1);

 strncpy(tmp_name, tempnam(NULL,".xpr"), 50);
 sprintf(line, "/bin/dmesg > %s", tmp_name);
 system(line);
 fd = fopen(tmp_name, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)   
  gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, line, -1);
  fclose(fd);
 }

 gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, "Processes:\n\n", -1);

 strncpy(tmp_name, tempnam(NULL,".xpr"), 50);
 sprintf(line, "/bin/ps -ax > %s", tmp_name);
 system(line);
 fd = fopen(tmp_name, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)
  gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, line, -1);
  fclose(fd);
 }

 gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, "\n\nPCI devices:\n\n", -1);

 fd = fopen("/proc/pci", "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)
  gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, line, -1);
  fclose(fd);
 }

 gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, "\n\nLocked files:\n\n", -1);

 fd = fopen("/proc/locks", "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)
  gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, line, -1);
  fclose(fd);
 }

 gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, "\n\nCurrent mounts:\n\n", -1);

 fd = fopen("/proc/mounts", "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)
  gtk_text_insert (GTK_TEXT (text2), NULL, NULL, NULL, line, -1);
  fclose(fd);
 }

 gtk_text_thaw (GTK_TEXT (text2));

 hbox = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_close), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void fs_info()
{
 fd = fopen("/proc/filesystems", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  gtk_entry_append_text (GTK_ENTRY (e1), line);
 }
 if(fd!=NULL) fclose(fd);
}

void sys_info()
{
 fd = fopen("/proc/version", "r");
 if(fd==NULL) return;
 fgets(line, 500, fd);
 gtk_entry_append_text (GTK_ENTRY (e1), lindex(line,0));
 gtk_entry_append_text (GTK_ENTRY (e2), lindex(line,2));
 if(fd!=NULL) fclose(fd);
 fd = fopen("/proc/loadavg", "r");
 if(fd==NULL) return;
 fgets(line, 500, fd);
 gtk_entry_append_text (GTK_ENTRY (e3), lindex(line,0));
 gtk_entry_append_text (GTK_ENTRY (e3), "  ");
 gtk_entry_append_text (GTK_ENTRY (e3), lindex(line,1));
 gtk_entry_append_text (GTK_ENTRY (e3), "  ");
 gtk_entry_append_text (GTK_ENTRY (e3), lindex(line,2));
 if(fd!=NULL) fclose(fd);
 fd = fopen("/proc/cmdline", "r");
 if(fd==NULL) return;
 fgets(line, 500, fd);
 gtk_entry_append_text (GTK_ENTRY (e4), line);
 if(fd!=NULL) fclose(fd);
}

void cpu_info()
{
 fd = fopen("/proc/cpuinfo", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  if(!match("cpu\t*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e1), lrange(line,1));
  if(!match("model*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e2), lrange(line,1));
  if(!match("vendor_id*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e3), lrange(line,1));
  if(!match("bogomips*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e4), lrange(line,1));
 }
 if(fd!=NULL) fclose(fd);
}

void mem_info()
{
 fd = fopen("/proc/meminfo", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  if(!match("MemTotal*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e1), lrange(line,1));
  if(!match("MemFree*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e2), lrange(line,1));
  if(!match("Buffers*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e3), lrange(line,1));
  if(!match("Cached*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e4), lrange(line,1));
  if(!match("SwapTotal*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e5), lrange(line,1));
  if(!match("SwapFree*", lindex(line,0)))
   gtk_entry_append_text (GTK_ENTRY (e6), lrange(line,1));
 }
 if(fd!=NULL) fclose(fd);
}

void dev_info()
{
 fd = fopen("/proc/devices", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, line, -1);
 }
 if(fd!=NULL) fclose(fd);
 gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, "\n\nInterrupts:\n", -1);
 fd = fopen("/proc/interrupts", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, line, -1);
 }
 if(fd!=NULL) fclose(fd);
 gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, "\n\nDMA addresses:\n", -1);
 fd = fopen("/proc/dma", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, line, -1);
 }
 if(fd!=NULL) fclose(fd);
}

void io_info()
{
 fd = fopen("/proc/ioports", "r");
 if(fd==NULL) return;
 while(fgets(line, 500, fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, line, -1);
 }
 if(fd!=NULL) fclose(fd);
}

void make_gui()
{
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 350, 400);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(CB_exit), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(CB_exit), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Xproc - System information");
 gtk_widget_set_uposition (window, 100, 100);
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 tips = gtk_tooltips_new();
 gtk_object_set_data (GTK_OBJECT (window), "Xproc", tips);

 vbox2 = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox2);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
 gtk_widget_show (vbox2);

 notebook = gtk_notebook_new ();
 gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
 gtk_box_pack_start (GTK_BOX (vbox2), notebook, TRUE, TRUE, 0);
 gtk_widget_show (notebook);

 frame = gtk_frame_new ("About Xproc");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("About");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Welcome to Xproc\n\nThis simple program shows important\ninformation about your system.\n\nTooltips should give you info on\nwhat each entry means.\n\nYou can get the latest version\nat http://devplanet.fastethernet.net\n\nThis program is (C) 1998\nPatrick Lambert <drow@darkelf.net>\n");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 frame = gtk_frame_new ("System information");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("General");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Kernel:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e1 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e1, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e1), FALSE);
 gtk_tooltips_set_tip(tips, e1, "This is your kernel", "");
 gtk_widget_show (e1);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);  
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Version:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e2 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e2, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e2), FALSE);
 gtk_tooltips_set_tip(tips, e2, "This is your kernel's version", "");
 gtk_widget_show (e2);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("System load:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e3 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e3, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e3), FALSE);
 gtk_tooltips_set_tip(tips, e3, "The system load for the past 1, 5 and 15 mins", "");
 gtk_widget_show (e3);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Boot cmd line:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e4 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e4, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e4), FALSE);
 gtk_tooltips_set_tip(tips, e4, "Command line for Linux boot", "");
 gtk_widget_show (e4);

 sys_info();

 frame = gtk_frame_new ("Main processor");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("Processor");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);                    
 gtk_container_add (GTK_CONTAINER (frame), vbox);      
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Arch type:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e1 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e1, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e1), FALSE);
 gtk_tooltips_set_tip(tips, e1, "This is the type of CPU: 486, 586, etc", "");
 gtk_widget_show (e1);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Model:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e2 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e2, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e2), FALSE);
 gtk_tooltips_set_tip(tips, e2, "CPU model", "");
 gtk_widget_show (e2);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Vendor:");                                       
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e3 = gtk_entry_new ();                             
 gtk_box_pack_start (GTK_BOX (hbox), e3, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e3), FALSE);
 gtk_tooltips_set_tip(tips, e3, "Your CPU maker", "");
 gtk_widget_show (e3);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("BogoMIPS:");                                       
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e4 = gtk_entry_new ();                             
 gtk_box_pack_start (GTK_BOX (hbox), e4, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e4), FALSE);
 gtk_tooltips_set_tip(tips, e4, "The BogoMIPS stats determined when calibrating the delay loop", "");
 gtk_widget_show (e4);

 cpu_info();

 frame = gtk_frame_new ("Memory information");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("Memory");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Total RAM memory:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e1 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e1, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e1), FALSE);
 gtk_tooltips_set_tip(tips, e1, "This is the amount of RAM minus the kernel", "");
 gtk_widget_show (e1);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);        
 gtk_widget_show (hbox);

 label = gtk_label_new ("Free memory:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e2 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e2, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e2), FALSE);
 gtk_tooltips_set_tip(tips, e2, "This is the amount of RAM left", "");
 gtk_widget_show (e2);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Buffers:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);                             

 e3 = gtk_entry_new ();                                           
 gtk_box_pack_start (GTK_BOX (hbox), e3, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e3), FALSE);
 gtk_tooltips_set_tip(tips, e3, "This is the memory in buffers, usualy free for programs to use", "");       
 gtk_widget_show (e3);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Cached memory:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);                             

 e4 = gtk_entry_new ();                                           
 gtk_box_pack_start (GTK_BOX (hbox), e4, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e4), FALSE);
 gtk_tooltips_set_tip(tips, e4, "This is the memory cached by the kernel, usualy free", "");       
 gtk_widget_show (e4);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Total swap:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);                             

 e5 = gtk_entry_new ();                                           
 gtk_box_pack_start (GTK_BOX (hbox), e5, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e5), FALSE);
 gtk_tooltips_set_tip(tips, e5, "This is the swap memory", "");       
 gtk_widget_show (e5);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Free swap:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);                             

 e6 = gtk_entry_new ();                                           
 gtk_box_pack_start (GTK_BOX (hbox), e6, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e6), FALSE);
 gtk_tooltips_set_tip(tips, e6, "This is the amount of swap left", "");       
 gtk_widget_show (e6);

 mem_info();

 frame = gtk_frame_new ("File systems supported");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("FS");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("File systems:");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 e1 = gtk_entry_new ();
 gtk_box_pack_start (GTK_BOX (hbox), e1, TRUE, TRUE, 0);
 gtk_entry_set_editable(GTK_ENTRY(e1), FALSE);
 gtk_tooltips_set_tip(tips, e1, "These are the filesystems supported by your kernel", "");
 gtk_widget_show (e1);

 fs_info();

 frame = gtk_frame_new ("Devices found");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("Devices");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_text_set_editable (GTK_TEXT (text), TRUE);
 
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);

 dev_info();

 gtk_text_thaw (GTK_TEXT (text));
 gtk_text_set_editable(GTK_TEXT(text), FALSE);
 gtk_tooltips_set_tip(tips, text, "These are the devices found by your kernel and their IRQ", "");
 gtk_widget_show (text);

 frame = gtk_frame_new ("I/O addresses");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("I/O");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_text_set_editable (GTK_TEXT (text), TRUE);
 
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);

 io_info();

 gtk_text_thaw (GTK_TEXT (text));
 gtk_text_set_editable(GTK_TEXT(text), FALSE);
 gtk_tooltips_set_tip(tips, text, "These are all the I/O ports of your hardware", "");
 gtk_widget_show (text);

 hbox = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
 gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Advanced");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_adv), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Exit");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_exit), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window);
}

int main(int argc, char *argv[])
{
 if(argv[1]!=NULL)
 {
  if(!strcasecmp(argv[1],"-v")) printf("%s\n", VERSION);
 }
 gtk_init(&argc, &argv);
 make_gui();
 gtk_main();
 return 0;
}
