//  UMenuBar.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UMenuBar.h"

UMenuBar::UMenuBar (UFrame* parent_, int frameSize_) : 
	UFrame (parent_, frameSize_)
{
	frameStyle = IN;
	popUpSize = 0;
	popUp = 0;
	selected = -1;
}

UMenuBar::~UMenuBar ()
{
	UComponent*	comp;
	int 		i;

	// This is the only handle for pop-up
	for (i=0; i<popUpSize; i++)
	{
		if (popUp[i] ==0) continue;
		delete popUp[i];
	}
	if (popUp) delete popUp;
	while (children.getSize())
	{
		comp = (UComponent*) children.at(0);
		if (comp==0) break;
		delete comp;
	}
}

void
UMenuBar::setFont (UFont* font_)
{
	int	i;
	font = font_;
	for (i=0; i<popUpSize; i++)
	{
		if (popUp[i] ==0) continue;
		popUp[i]->setFont (font_);
		if (popUp[i]->cascade)
		{
			popUp[i]->cascade->setFont(font_);
		}
	}
}

const UBestSize&
UMenuBar::getBestSize()
{
	packItems();
	return bestSize;
}

void
UMenuBar::packItems()
{
	int		i;
	UBestSize	best;
	int		maxHeight;
	int		x;
	int		inset;

	maxHeight = 0;
	popUp[3]->packItems ();
	for (i=0; i<popUpSize; i++)
	{
		if (popUp[i]==0) continue;
		popUp[i]->packItems ();
		if (popUp[i]->cascade==0) continue;
		best = popUp[i]->cascade->getBestSize();
		if (best.height > maxHeight) maxHeight = best.height;
	}
	inset = 4;
	x = inset;
	for (i=0; i<popUpSize; i++)
	{
		if (popUp[i]==0) continue;
		if (popUp[i]->cascade==0) continue;
		best = popUp[i]->cascade->getBestSize();
		popUp[i]->cascade->place (x, frameSize+inset, 
			-(x+best.width), frameSize+inset);
		x+=best.width + maxHeight;
	}
	bestSize.height = maxHeight+2*inset;
	bestSize.width = x;
}

UMenuBar::UStatus
UMenuBar::deleteMenuItem (UPopUp* popUp_)
{
	int	i;
	for (i=0; i<popUpSize; i++)
	{
		if (popUp[i] == popUp_)
		{
			popUp[i] = 0;
			return OK;
		}
	}
	return ERROR;
}

//
// The popup cascade should be child of menubar 
//
UMenuBar::UStatus
UMenuBar::addMenuItem (UPopUp* popUp_, int pos)
{
	UPopUp**	newArray;
	int		newSize;
	int		i;

	newSize = (pos < 0) ? popUpSize +1 : pos + 1;
	if (newSize <= popUpSize)
	{
		popUp[pos] = popUp_;
		return OK;
	}
	newArray = new UPopUp* [newSize];
	if (newArray==0) return ERROR;
	if (popUpSize>0)
	{
		memcpy (newArray, popUp, sizeof (UPopUp*) * popUpSize);
		delete popUp;
	}
	for (i=popUpSize; i< newSize; i++) newArray[i] = 0;
	popUpSize = newSize;
	popUp = newArray;
	popUp[popUpSize-1] = popUp_;
	return OK;
}

void
UMenuBar::eventDown (UEvent* event)
{
	int			rootX;
	int			rootY;
	int			wX;
	int			wY;
	int			newPos;
	Window			w;
	Window			chld;
	UPopUp*			selectedPopUp;
	UComponent*		selectedItem;
	int			selectedPos;
	UMenuItem*		menuItem;
	UEvent			sendEvent;
	unsigned int		mask;

	switch (event->type)
	{
	case UEvent::TIMER:
		break;
	case UEvent::X:
	switch (event->xevent.type)
	{
	case ButtonRelease:
		if (event->xevent.xbutton.window!=window) return;
		if (event->xevent.xbutton.button != Button1) return;
		if (selected <0)
		{
			return;
		}
		// No selection is made yet.
		if (!popUp[selected]->getSelected (&selectedPopUp, 
			&selectedItem, &selectedPos))
		{
			return;
		}
		
		menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		if (menuItem) menuItem->unhighlight();
		XUngrabPointer (top->display, CurrentTime);
		popUp[selected]->highlightItem (
			event->xevent.xbutton.x_root,
			event->xevent.xbutton.y_root);
		popUp[selected]->hide ();
		selected = -1;
		sendEvent.type = UEvent::MENU_SELECTION;
		sendEvent.client = this;
		sendEvent.popUp = selectedPopUp;
		sendEvent.menu = selectedItem;
		sendEvent.value = selectedPos;
		// get the selected value here!!
		parent->eventUp (&sendEvent);
		break;
	case ButtonPress:
		if (event->xevent.xbutton.window!=window) return;
		if (event->xevent.xbutton.button != Button1) return;
		if (selected < 0) return;
		//menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		//if (menuItem) menuItem->unhighlight();
		XUngrabPointer (top->display, CurrentTime);
		popUp[selected]->highlightItem (
			event->xevent.xbutton.x_root,
			event->xevent.xbutton.y_root);
		if (popUp[selected]->getSelected (&selectedPopUp, 
			&selectedItem, &selectedPos))
		{
			popUp[selected]->hide ();
			// send menu event...
			sendEvent.type = UEvent::MENU_SELECTION;
			sendEvent.client = this;
			sendEvent.popUp = selectedPopUp;
			sendEvent.menu = selectedItem;
			sendEvent.value = selectedPos;
			// get the selected value here!!
			parent->eventUp (&sendEvent);
		}
		else
		{
			popUp[selected]->hide ();
		}

		selected = -1;
		break;
	case EnterNotify:
	case LeaveNotify:
		// see if we are in a child
		if (selected<0) break;

		if (event->xevent.xcrossing.mode==NotifyUngrab)
		{
			menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
			if (menuItem) menuItem->unhighlight();
			popUp[selected]->hide ();
			selected=-1; 
			break;
		}
		newPos = findMenu (event->xevent.xcrossing.x, 
			event->xevent.xcrossing.y);
		if (newPos < 0 || newPos==selected) return;

		// move to new place
		menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		if (menuItem) menuItem->unhighlight();
		popUp[selected]->hide ();
		selected = newPos;
		menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		if (menuItem) menuItem->highlight();

		XTranslateCoordinates (top->display,
			popUp[selected]->cascade->window, top->root,
			0,popUp[selected]->cascade->rectangle.height+2, 
			&rootX, &rootY, &w);

		//popUp[selected]->packItems ();
		popUp[selected]->move (rootX, rootY);
		popUp[selected]->show ();
		break;
	case MotionNotify:
		if (selected ==-1) return;
		while (XCheckTypedWindowEvent (top->display, window,
			MotionNotify, &event->xevent));
		if (event->xevent.xmotion.is_hint)
		{
			XQueryPointer (top->display, window, &w, &chld, 
				&rootX, &rootY, &wX, &wY, &mask);
			popUp[selected]->highlightItem (rootX, rootY);
			return;
			
		}
		// Make translation
		popUp[selected]->highlightItem (
			event->xevent.xmotion.x_root,
			event->xevent.xmotion.y_root);
		break;
	default:
		break;
	}
	default:
		break;
	}
}

void 
UMenuBar::eventUp (UEvent* event)
{
	int		cindex;
	Window		w;
	int		rootX;
	int		rootY;
	int		status;
	UMenuItem*	menuItem;

	switch (event->type)
	{
	case UEvent::TIMER:
		break;
	case UEvent::PRESSED:
		break;
	case UEvent::X:
	switch (event->xevent.type)
	{
	case ButtonRelease:
		if (event->xevent.xbutton.button != Button1) return;
		XUngrabPointer (top->display, CurrentTime);
		if (selected ==-1) return;
		popUp[selected]->hide ();

		// get the selected value here!!
		menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		if (menuItem) menuItem->unhighlight();
		popUp[selected]->unhighlightItem();
		selected = -1;
		break;
	case ButtonPress:
		if (event->xevent.xbutton.button != Button1) return;
		cindex = findMenu (event->xevent.xany.window);
		if (cindex <0) return;
		selected = cindex;
        	status = XGrabPointer( top->display, window,
			False, ButtonPressMask | ButtonReleaseMask |
			EnterWindowMask | LeaveWindowMask | PointerMotionHintMask |
			PointerMotionMask,
			GrabModeAsync, GrabModeAsync,
			None, None, CurrentTime);
		if (status != GrabSuccess && status != AlreadyGrabbed)
		{
			cerr << "warn: pointer grab failed.\n";
			return;
		}
		menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		if (menuItem) menuItem->highlight();

		XTranslateCoordinates (top->display,
			popUp[selected]->cascade->window, top->root,
			0,popUp[selected]->cascade->rectangle.height+2, 
			&rootX, &rootY, &w);
		//popUp[selected]->packItems ();
		popUp[selected]->move (rootX, rootY);
		popUp[selected]->show ();
		break;
	default:
		break;
	}
	default:
		break;
	}
}
int
UMenuBar::findMenu (int x, int y)
{
	int		retVle;
	int		cindex;
	UPopUp*		pup=0;
	UComponent* 	casc=0;

	retVle=-1;
	for (cindex=0; cindex<popUpSize; cindex++)
	{
		casc = (UComponent*) popUp[cindex]->cascade;
		if (casc==0) continue;
		if (casc->getMenu()==0) continue;
		if (casc->rectangle.x <= x 
		  && x <= casc->rectangle.x + casc->rectangle.width
		  && casc->rectangle.y <= y 
 		  && y <= casc->rectangle.y + casc->rectangle.height)
		{
			pup = popUp[cindex]; 
			retVle = cindex;
			break;
		}
	}
	return retVle;
}

int
UMenuBar::findMenu (Window w)
{
	int		retVle;
	int		cindex;
	UPopUp*		pup=0;
	UComponent* 	casc=0;

	retVle=-1;
	for (cindex=0; cindex<popUpSize; cindex++)
	{
		casc = (UComponent*) popUp[cindex]->cascade;
		if (casc->getMenu()==0) continue;
		if (casc!=0 && casc->window == w)
		{
			pup = popUp[cindex]; 
			retVle = cindex;
			break;
		}
	}
	return retVle;
}


int
UMenuBar::isA (UComponent::UType type_)
{
	if (type_ == UComponent::MENUBAR) return 1;
	return UFrame::isA (type_);
}
