//  UInput.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//

#include <iostream.h>
#include "UString.h"
#include "UCommon.h"

#define 	INPUTCACHE_SIZE 128
#define 	UINPUT_STATE_SIZE 32
#define		UINPUT_MAX_SEGMENTS 5

class UInputSearch
{
public:
			UInputSearch ();
			~UInputSearch ();
	void		addItem (const unsigned char* key, 
				const UCS2* code);
	int		addItem (const char *line);
	int		binarySearch (const unsigned char *key);
	UCS2**		codes;
	unsigned char**	keys;
	int		arraySize;
	int		size;
};

class UInputCache
{
public:
			UInputCache (int size_);
			~UInputCache ();
	int		size;
	UInputSearch**	search;
};

class UInput
{
public:
	enum UStatus 		{ OK, ERROR };
	enum UMatchType		{ NO_MATCH, DID_MATCH, DID_MATCH0,
				MAY_MATCH, MAY_MATCH0, MATCH };
				UInput ();
				~UInput ();
	UStatus			rename (const char* name);
	inline const char* 	getName() const { return name; };
	UStatus			makeUnicodeMap();

	void			resetState ();
	void			deleteLast ();
	UCS2*  			translate (const int asci);

	inline const int	getStateSize () {return stateSize; }
	inline UCS2*		getUCS2 () { return ((stateSize==0) ? 0 
					: UCS2Get (stateString)); }
private:
	int			canGive (int doGive_=0);
	UMatchType		translate (UInputSearch* search_, 
					unsigned char* in_, int size_, int* index);
	UCS2*			translateAdd (UCS2* ucs2_, 
					const unsigned char* str);

	int			loadCache (const char* name);
	int			loadCache (ifstream* file, const char* filename=0);

	// This is what the bloke typed in
	unsigned char		stateString[UINPUT_STATE_SIZE];
	int			stateSize;

	// This shows the starting partitions in stateString
	unsigned short		partition [UINPUT_MAX_SEGMENTS];

	// This shows the index that belongs to the partition
	UCS2			accumulated[2][2];

	// This is the current bucket in inputCache
	unsigned short		bucket;

	char*			name;
	UInputCache*		inputCache;
	static char*		EXTENSION;
};
