//  UXKinput.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef __ux_kinput2__
#define __ux_kinput2__

#include "UXInput.h"

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "ConvProto.h"

//
// This is a per-display structure.
// 
typedef struct {
    Display	*display;
    Atom	profileAtom;	/* "_CONVERSION_PROFILE" */
    Atom	typeAtom;	/* "_CONVERSION_ATTRIBUTE_TYPE" */
    Atom	versionAtom;	/* "PROTOCOL-2.0" */
    Atom	reqAtom;	/* "CONVERSION_REQUEST" */
    Atom	notifyAtom;	/* "CONVERSION_NOTIFY" */
    Atom	endAtom;	/* "CONVERSION_END" */
    Atom	endReqAtom;	/* "CONVERSION_END_REQUEST" */
    Atom	attrAtom;	/* "CONVERSION_ATTRIBUTE" */
    Atom	attrNotifyAtom;	/* "CONVERSION_ATTRIBUTE_NOTIFY" */
} ConversionAtoms;

//
// When we register a context with X we pass an instance of this 
// class. 
//
class UXKinput : public UXInput
{
public:
				UXKinput (UWidgetX* uwidgetIn);
	virtual			~UXKinput ();
	virtual void		propertyChangeHandler (const XEvent* event);
	virtual void		noEventHandler (const XEvent* event);
protected:
	// This is from conversion context
	Atom			convatom;
	Window			convowner;
	Atom			property;
	
	virtual UStatus		uStartIM ();
	virtual void		uEndIM();
	virtual void		uChangeIM (UAttribute attrIn);

	// The following functions should register an event handler
	// that calls the functions above. This is widget set dependent.
	// override this to suit your event handling style

	virtual void		addEventHandler (const UInputEvent eventType);
	virtual void		removeEventHandler (const UInputEvent eventType);

	unsigned long 		getInputStyle();
	long 			getCaptureMethod();
	ConversionAtoms*	getAtoms();

	UStatus 		setConvAttrProp (const UAttribute attribute, 
					const Atom prop);

	UStatus 		checkProtocols (const ConversionAtoms *);

	static	ConversionAtoms*	convatomArray;
	static  short			convatomSize;
	static  short			convatomArraySize;
	static 	XContext		convertPrivContext;
	static 	int			instances;

//------------------------------------------------------------------------------
// interface
//------------------------------------------------------------------------------

	void endConversion(Widget w, Atom catom, Boolean throwaway);
	void changeConversionAttributes(Widget w, Atom catom, ArgList attrs, 
			Cardinal nattrs);
	int  beginConversionWithAttributes(Widget w, Atom catom, Atom tatom, 
		void (*inputproc)(), void (*startendproc)(), 
		XtPointer client_data, ArgList attrs, Cardinal nattrs);
};

#endif /* __ux_kinput2__ */
