/*
 * static char *rcsid_includes_h =
 *   "$Id: includes.h,v 1.3 1998/04/16 01:36:56 master Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1994 Mark Wedel
    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to master@rahul.net
*/

/* This is a copy of the 'includes' file from the server.  Stuff
 * has been added an removed in order for this to work properly
 * with the client.  This defiens a lot of machine/os/type flags, and
 * is thus very useful
 *
 * This includes many files.  copies of the osf.h, sgi.h and sunos.h
 * files are included in this file to provide function prototypes
 * and other things that were needed.
 */

#ifndef INCLUDES_H
#define INCLUDES_H

#define ASSERT(x)
#if 0
#define ASSERT(x) if (!(x)) { kill(getpid(),11);}
#endif

#if defined(osf1) && !defined(__osf__)
#  define	__osf__
#endif

#if defined(sgi) && !defined(__sgi__)
#  define __sgi__
#endif

#ifdef sun
#  ifndef __sun__
#    define __sun__
#  endif
#endif

#if defined(ultrix) && !defined(__ultrix__)
#  define __ultrix__
#endif

#include <stdio.h>
#include <stdarg.h>	/* varargs */
#include <string.h>	/* lots of stuff, malloc is one */
#include <stdlib.h>
#include <memory.h>	/* for memset */
/*#include <varargs.h>*/


/* tempnam() is not declared ifdef __STRICT_ANSI__ or on NeXT's*/
#if defined(NeXT)
extern char *tempnam(char *dir, char *pfx);
#endif


#if defined(__sun__) /* && defined(SVR4) */
#include <unistd.h>	/* gives us getpid */
#endif

#if defined(__pyrsoft)
#include <unistd.h>     /* gives us SC_OPEN_MAX */
#endif

#include <sys/types.h>
#include <sys/time.h>

#if defined(_IBMR2) 
#  include <time.h>
#  include <math.h> /* Ack!  Can anyone with IBM tell me what requires this? */
#endif

#ifndef sgi
#  include <sys/timeb.h>
#endif

#ifdef __osf__
#  include <unistd.h>
/*
 * Made this useless file to avoid warnings when compiling on a DEC/OSF1
 * machine, since it is missing a few prototypes.
 * Created:	30-12-93
 * Author:	Kjetil W. J|rgensen, <jorgens@pvv.unit.no>
 */

#ifndef __alpha
long random(void);
long srandom (int);
char *crypt(char *, char *);
void *memset(void *, int, size_t);
int ftime(struct timeb *);
void bcopy(char *, char *, int);
void bzero(char *, int);

#endif

#endif

#ifdef __sgi__
#  include <unistd.h>
#  include <math.h>
/*
 * Made this useless file to avoid warnings when compiling on a SGI,
 * since it is missing a few prototypes.
 * Created:	03-12-93
 * Author:	Kjetil W. J|rgensen, <jorgens@pvv.unit.no>
 */

void bcopy(const void *, void *, int);
/*char *crypt(char *, char *);*/ /* Supposedly not needed with irix 5.2*/
int kill (pid_t, int);


#endif

#ifdef linux
#  include <unistd.h>
#endif

#if defined (__sun__) && defined(StupidSunHeaders)

#ifndef SVR4

extern int malloc_debug(int);
int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
char _filbuf();
char *crypt(char *, char *);
char *strdup_local(char *);
int _flsbuf(char *, int);
int cfree(char *);
int fclose(FILE *);
int fgetc(FILE *);
int printf(char *, ...);
int fprintf(FILE *, char *, ...);
int vprintf(char *, va_list);
int vsprintf(char *, char *, va_list);
int vfprintf(FILE *, char *, va_list);
int fputs(char *, FILE *);
int fread(char *, int, int, FILE *);
int fwrite(char *, int, int, FILE *);
int scanf(char *, ...);
int fscanf(FILE *, char *, ...);
int sscanf(char *, char *, ...);
int ftime(struct timeb *);
int getdtablesize(void);
int gethostname(char *, int);
int gettimeofday(struct timeval *, struct timezone *);
int ioctl(int, int, ...);
int pclose(FILE *);
int puts(char *);
int rename(char *, char *);
int setpgrp(int, int);
int srandom(int);
int strcasecmp(char *, char *);
int strftime(char *, int, char *, struct tm *);
int strncasecmp(char *, char *, int);
int system(char *);
int ungetc(int, FILE *);
long random(void);
long strtol(char *, char **, int);
time_t time(time_t *);
void bcopy(char *, char *, int);
void bzero(char *, int);
void fflush(FILE *);
void fseek (FILE *, long, int);
void perror(char *);
void rewind(FILE *);

#endif
#endif

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#endif /* INCLUDES_H */
