/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A curve

    Copyright (c) 1997-1998 Mark Danks. mdanks@cybermed.ucsd.edu
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_CURVE_H_
#define INCLUDE_CURVE_H_

#include "Geos/polygon.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    curve
    
    Creates a curve

KEYWORDS
    geo
    
DESCRIPTION
    
-----------------------------------------------------------------*/
class GEM_EXTERN curve : public polygon
{
    CPPEXTERN_HEADER(curve, polygon)

    public:

	    //////////
	    // Constructor
    	curve(t_floatarg numInputs);
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~curve();

    	//////////
    	// Do the rendering
    	virtual void 	render(GemState *state);

    	//////////
    	// How the object should be drawn
    	virtual void	typeMess(t_symbol *type);

    	//////////
    	// Resolution callback
    	void	    	resolutionMess(int res);
    	
    	//////////
    	// The rendering resolution
    	int 	    	m_resolution;

    private:
    	
    	//////////
    	// Static member functions
    	static void 	resolutionMessCallback(void *data, t_floatarg res);
};

#endif	// for header file
