/* gdk_t1lib.h: GDK wrappers for t1lib.
   (c) 1998 David Huggins-Daines <bn711@freenet.carleton.ca>
   You may modify and distribute this file under the terms of the GNU
   General Public License, version 2, or any later version, at your
   convenience. See the file COPYING for details. */

/* Note that I've made no attempt so far to adapt the behaviour of
   t1lib to more closely approach that of the standard GDK text
   functions.  I hope to add support for a more sophisticated font
   database, so that we can have "drop-in" replacements for standard
   text drawing functions. */

#ifndef GDKT1LIB_H
#define GDKT1LIB_H
#include "t1lib.h"
#include "t1libx.h"
#include <gdk/gdk.h>

/* Initializes t1lib to the proper specifications. Takes the same
   argument as T1_InitLib and returns the same value. */

gpointer gdk_t1lib_init (gint log);

/* These are all just inline functions that pass the corresponding X
   data structures to t1lib's functions.  This might cause some
   problems as they sometimes manipulate internal GC params... we'll
   have to wait and see. */

GLYPH *gdk_t1lib_set_char ( GdkDrawable *d, GdkGC *gc, gint mode,
			    gint x, gint y,
			    gint FontID, gchar charcode,
			    gfloat size, gfloat angle);
GLYPH *gdk_t1lib_set_string ( GdkDrawable *d, GdkGC *gc,
			      gint mode, gint x, gint y,
			      gint FontID, gchar *string,
			      gint len, glong spaceoff,
			      gint modflag, gfloat size,
			      gfloat angle);
GLYPH *gdk_t1lib_set_char_aa ( GdkDrawable *d, GdkGC *gc,
			       gint mode, gint x, gint y,
			       gint FontID, gchar charcode,
			       gfloat size, gfloat angle);
GLYPH *gdk_t1lib_set_string_aa ( GdkDrawable *d, GdkGC *gc,
				 gint mode, gint x, gint y,
				 gint FontID, gchar *string,
				 gint len, glong spaceoff,
				 gint modflag, gfloat size,
				 gfloat angle);

#endif
