/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK                                                            *
 * Modul:     filesel.c                                                      *
 *            common functions from paul and paulscan for fileselection      *
 * Author:    Andreas Tille                                                  *
 * Datum:     14.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <unistd.h>
#include "paul.h"

static void FileSelectionMove2(GtkFileSelection *fs, char *name)
/* Set the current file in filelist to name 
 */
{
   gchar *filename;
   int    i = -1;
   
   if ( !fs || !name || !*name ) return;

   while ( gtk_clist_get_text(GTK_CLIST(fs->file_list), ++i, 0, &filename) ) 
      if ( filename && !strcmp(filename, name) ) {
         gtk_clist_select_row(GTK_CLIST(fs->file_list), i, 0);
         gtk_clist_moveto(GTK_CLIST(fs->file_list), i, 0, 0.5, 0.0);
         break;
      }
}

char *FilenameExtractFromSelection(GtkFileSelection *fs, PICTURE *bild)
/* useful for both paul and paulscan, that's why this was extracted from FileSaveOK()
 * --- Parameter: ---
 * GtkFileSelection *fs                 : fileselection widget to get name from
 * PICTURE          *bild               : picture structure which filename has to be set
 * --- Return: ---
 * char *FilenameExtractFromSelection() : new filename if it was changed and paul's
 *                                        list has to be updated, else NULL 
 */
{
   char  *filename, *cwd;
   int   flag = 0;  /* determine if paul's filename has to be set.  This can't be *
                     * done in paulscan, so we have to decide here                */

   filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
   cwd      = getcwd(NULL, 512);
   if ( cwd ) {
      register char *dp = cwd - 1, *fp = filename - 1;

      while ( *++fp && *++dp ) if ( *dp != *fp ) break;
      if ( !*dp ) filename = fp + 1;
      free(cwd);
   }
   if ( (cwd = strstr(filename, ".png")) ) *cwd = 0;
   if ( (cwd = strstr(filename, ".tif")) ) *cwd = 0;
   if ( strcmp(bild->file, filename) ) {
      FREE(bild->file);
      assert ( (bild->file = strdup(filename)) );
      bild->flag |= QUIET;
      flag = 1;
   }
   gtk_widget_destroy(GTK_WIDGET(fs));
   if ( flag ) return bild->file;
   return NULL;
}


void FileSelectionLoadSave(PAUL *p, GtkSignalFunc func, char *name, char *title)
{
   static GtkWidget *window = NULL;

   if ( window ) {
      gtk_widget_destroy(window);
      return;
   }
   
   if ( title ) window = gtk_file_selection_new(title);

   gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
   gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);

   if ( name ) gtk_file_selection_set_filename(GTK_FILE_SELECTION(window), name);
   gtk_object_set_user_data(GTK_OBJECT(window), p);

   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window)->ok_button), "clicked", 
                      GTK_SIGNAL_FUNC(func), window);
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(window)->cancel_button), "clicked", 
                             GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
  
   gtk_widget_show(window);
   FileSelectionMove2(GTK_FILE_SELECTION(window), name);
}



