// fl_cursor.C

// Change the current cursor.

// Under X the cursor is attached to the X window.  I tried to hide
// this and pretend that changing the cursor is a drawing function.
// This avoids a field in the Fl_Window, and I suspect is more
// portable to other systems.

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/x.H>
#ifndef WIN32
#include <X11/cursorfont.h>
#endif
#include <FL/fl_draw.H>

void fl_cursor(uchar c, uchar fg, uchar bg) {
  Fl::first_window()->cursor(c,fg,bg);
}

#ifdef WIN32

void Fl_Window::cursor(uchar c, uchar, uchar) {
  if (!shown()) return;
  if (c > FL_CURSOR_INSERT) {
    i->cursor = 0;
  } else if (c == FL_CURSOR_DEFAULT) {
    i->cursor = fl_default_cursor;
  } else {
    LPSTR n;
    switch (c) {
    case FL_CURSOR_ARROW:	n = IDC_ARROW; break;
    case FL_CURSOR_CROSS:	n = IDC_CROSS; break;
    case FL_CURSOR_WAIT:	n = IDC_WAIT; break;
    case FL_CURSOR_INSERT:	n = IDC_IBEAM; break;
    case FL_CURSOR_HELP:	n = IDC_HELP; break;
    case FL_CURSOR_HAND:	n = IDC_UPARROW; break;
    case FL_CURSOR_MOVE:	n = IDC_SIZEALL; break;
    case FL_CURSOR_N:
    case FL_CURSOR_S:
    case FL_CURSOR_NS:		n = IDC_SIZENS; break;
    case FL_CURSOR_NE:
    case FL_CURSOR_SW:		n = IDC_SIZENESW; break;
    case FL_CURSOR_E:
    case FL_CURSOR_W:
    case FL_CURSOR_WE:		n = IDC_SIZEWE; break;
    case FL_CURSOR_SE:
    case FL_CURSOR_NW:		n = IDC_SIZENWSE; break;
    default:			n = IDC_NO; break;
    }
    i->cursor = LoadCursor(NULL, n);
  }
  SetCursor(i->cursor);
}

#else

void Fl_Window::cursor(uchar c, uchar fg, uchar bg) {
  if (!shown()) return;
  Cursor cursor;
  int deleteit = 0;
  if (!c) {
    cursor = None;
  } else if ((c-1)*2>=XC_num_glyphs) {
    static Cursor blank;
    if (!blank) {
      // make a blank cursor
      static char data[1] = {0};
      XColor dummy;
      Pixmap p = XCreateBitmapFromData(
	fl_display, RootWindow(fl_display, fl_screen), data, 1, 1);
      blank = XCreatePixmapCursor(fl_display, p, p, &dummy, &dummy, 0, 0);
      XFreePixmap(fl_display, p);
    }
    cursor = blank;
  } else {
    cursor = XCreateFontCursor(fl_display, (c-1)*2);
    deleteit = 1;
    XColor fgc;
    uchar r,g,b;
    Fl::get_color(fg,r,g,b);
    fgc.red = r<<8; fgc.green = g<<8; fgc.blue = b<<8;
    XColor bgc;
    Fl::get_color(bg,r,g,b);
    bgc.red = r<<8; bgc.green = g<<8; bgc.blue = b<<8;
    XRecolorCursor(fl_display, cursor, &fgc, &bgc);
  }
  XDefineCursor(fl_display, fl_xid(this), cursor);
  if (deleteit) XFreeCursor(fl_display, cursor);
}

#endif
