/* $Id: vline.c,v 1.8 1998/09/20 21:22:34 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGIdrawvline(ggi_visual *vis,int x,int y,int height)
{
	uint16 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis)/2;
	uint16 color=LIBGGI_GC_FGCOLOR(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=((uint16 *)LIBGGI_CURWRITE(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=color; 
	
	return 0;
}

int GGIdrawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint16 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis)/2;
	uint16 color=LIBGGI_GC_FGCOLOR(vis);

	/* no Clipping */
	ptr=((uint16 *)LIBGGI_CURWRITE(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=color; 
	
	return 0;
}

int GGIputvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint16 *ptr,*pixels=(uint16 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis)/2;

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buffer =((uint16 *)buffer)+diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=((uint16 *)LIBGGI_CURWRITE(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*ptr=*(pixels++); 
	
	return 0;
}

int GGIgetvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint16 *ptr,*pixels=(uint16 *)buffer;
	int w=LIBGGI_FB_R_STRIDE(vis)/2;

	if (x<0||y<0||x>=LIBGGI_VIRTX(vis)||y+height>LIBGGI_VIRTY(vis)) return -1;

	ptr=((uint16 *)LIBGGI_CURREAD(vis))+y*w+x;

	for(;height>0;height--,ptr+=w) 
		*(pixels++)=*ptr; 
	
	return 0;
}

