/* $Id: copybox.c,v 1.7 1998/09/26 03:20:42 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include "lin4lib.h"

/*****************************************/
/* 4-bpp screen->screen rectangular copy */
/*****************************************/

int GGI_lin4_copybox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{
	uint8 *obox,*nbox;
	int linew=LIBGGI_FB_W_STRIDE(vis);
	int line;
	int left, right;
	
	CHECKXYWH(vis,x,y,w,h);
	CHECKXYWH(vis,nx,ny,w,h);
	
	/* if x is odd, left pixel dangles. */
	/* if x is odd and w is even, right dangles. */
	/* if x is even and w is odd, right dangles. */

	left  = (x & 0x01);
	right = (x ^ w) & 0x01;
	w -= left + right;
	
	if (ny < y) {

		obox=(uint8 *)(LIBGGI_CURWRITE(vis))+y*linew+(x>>1);
		nbox=(uint8 *)(LIBGGI_CURWRITE(vis))+ny*linew+(nx>>1);
		if (left) {
			nbox++; obox++;
		}
		for (line=0;line<h;line++,obox+=linew,nbox+=linew) {
			
			if (left)
				*(nbox-1) = (*(nbox-1) & 0xF0) | *(obox-1);
			
			memmove(nbox,obox,w>>1);
			
			if (right)
				*(nbox+w) = (*(nbox+w) & 0x0F) | (*(obox+w) << 4);
		}
		
	} else {
		obox=(uint8 *)(LIBGGI_CURWRITE(vis))+(y+h-1)*linew+(x>>1);
		nbox=(uint8 *)(LIBGGI_CURWRITE(vis))+(ny+h-1)*linew+(nx>>1);
		if (left) {
			nbox++; obox++;
		}
		for (line=0;line<h;line++,obox-=linew,nbox-=linew) {

			if (left)
				*(nbox-1) = (*(nbox-1) & 0xF0) | *(obox-1);
			
			memmove(nbox,obox,w>>1);
			
			if (right)
				*(nbox+w) = (*(nbox+w) & 0x0F) | (*(obox+w) << 4);
		}
	}
	return 0;
}
