/* $Id: ggi-auto.inc,v 1.2 1998/09/20 18:19:33 steve Exp $
***************************************************************************

   Common GGI_AUTO handling code.
   
   Copyright (C) 1998  Andrew Apted  <andrew.apted@ggi-project.org>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

static void _GGIhandle_ggiauto(ggi_mode *mode, int def_x, int def_y)
{
	if (mode->frames == GGI_AUTO) {
		mode->frames = 1;
	}

	if (mode->visible.x==GGI_AUTO && mode->virt.x==GGI_AUTO) {
		mode->visible.x = mode->virt.x = def_x;
		
	} else if (mode->visible.x == GGI_AUTO) {
		mode->visible.x = mode->virt.x;
		
	} else if (mode->virt.x == GGI_AUTO) {
		mode->virt.x = mode->visible.x;
	}

	if (mode->visible.y==GGI_AUTO && mode->virt.y==GGI_AUTO) {
		mode->visible.y = mode->virt.y = def_y;
		
	} else if (mode->visible.y == GGI_AUTO) {
		mode->visible.y = mode->virt.y;
		
	} else if (mode->virt.y == GGI_AUTO) {
		mode->virt.y = mode->visible.y;
	}

	if (mode->dpp.x == GGI_AUTO) {
		mode->dpp.x = (GT_SCHEME(mode->graphtype)==GT_TEXT) ? 8 : 1;
	}

	if (mode->dpp.y == GGI_AUTO) {
		mode->dpp.y = (GT_SCHEME(mode->graphtype)==GT_TEXT) ? 8 : 1;
	}
}
