/* $Id: text.c,v 1.13 1998/09/24 01:24:11 marcus Exp $
***************************************************************************

   Display-monotext: displaying text

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include "monotext.h"

#undef putc


int GGI_monotext_putc(ggi_visual *vis, int x, int y, char c)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);

	int char_w, char_h;
	int err;
	
	ggiGetCharSize(vis, &char_w, &char_h);

	UPDATE_MOD(mt, x, y, char_w, char_h);
	
	if ((err = mt->mem_opdraw->putc(vis, x, y, c)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}
