/* $Id: stubs.c,v 1.14 1998/09/23 21:38:14 marcus Exp $
***************************************************************************

   Display-multi: stubs

   Copyright (C) 1995 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#include "multi_defs.h"


int GGI_multi_getpixel(ggi_visual *vis, int x, int y, ggi_pixel *col)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetPixel(mm->vis_list->vis, x, y, col);
}

int GGI_multi_gethline(ggi_visual *vis, int x, int y, int w, void *buffer)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetHLine(mm->vis_list->vis, x, y, w, buffer);
}

int GGI_multi_getvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetVLine(mm->vis_list->vis, x, y, h, buffer);
}

int GGI_multi_getbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetBox(mm->vis_list->vis, x, y, w, h, buffer);
}

int GGI_multi_getgamma(ggi_visual *vis, ggi_float *r, ggi_float *g, ggi_float *b)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetGamma(mm->vis_list->vis, r, g, b);
}

int GGI_multi_getgammamap(ggi_visual *vis, int start, int len, ggi_color *cmap)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetGammaMap(mm->vis_list->vis, start, len, cmap);
}

int GGI_multi_getcharsize(ggi_visual *vis, int *width, int *height)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetCharSize(mm->vis_list->vis, width, height);
}

ggi_pixel GGI_multi_mapcolor(ggi_visual *vis, ggi_color *col)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiMapColor(mm->vis_list->vis, col);
}

int GGI_multi_unmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiUnmapPixel(mm->vis_list->vis, pixel, col);
}

int GGI_multi_getpalvec(ggi_visual *vis, int start, int len, ggi_color *cmap)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetPalette(mm->vis_list->vis, start, len, cmap);
}

/* ---------------------------------------------------------------------- */

void GGI_multi_gcchanged(ggi_visual *vis, int mask)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	DPRINT("display-multi: GCCHANGED %d\n", mask);

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {

		ggi_gc *gc = LIBGGI_GC(vis);
		ggi_color tmp;

		if (mask & GGI_GCCHANGED_FG) {
			GGI_multi_unmappixel(vis, gc->fg_color, &tmp);
			ggiSetGCForeground(cur->vis,
				ggiMapColor(cur->vis, &tmp));
		}
		
		if (mask & GGI_GCCHANGED_BG) {
			GGI_multi_unmappixel(vis, gc->bg_color, &tmp);
			ggiSetGCBackground(cur->vis,
				ggiMapColor(cur->vis, &tmp));
		}

		if (mask & GGI_GCCHANGED_CLIP) {
			ggiSetGCClipping(cur->vis, 
				gc->cliptl.x, gc->cliptl.y,
				gc->clipbr.x, gc->clipbr.y);
		}
	}
}

int GGI_multi_putpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiPutPixel(cur->vis, x, y, col) != 0) err--;
	}

	return err;
}

int GGI_multi_drawpixel(ggi_visual *vis, int x, int y)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiDrawPixel(cur->vis, x, y) != 0) err--;
	}

	return err;
}

int GGI_multi_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiDrawBox(cur->vis, x, y, w, h) != 0) err--;
	}

	return err;
}

int GGI_multi_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiPutHLine(cur->vis, x, y, w, buffer) != 0) err--;
	}

	return err;
}

int GGI_multi_putvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiPutVLine(cur->vis, x, y, h, buffer) != 0) err--;
	}

	return err;
}

int GGI_multi_putbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiPutBox(cur->vis, x, y, w, h, buffer) != 0) err--;
	}

	return err;
}

int GGI_multi_fillscreen(ggi_visual *vis)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiFillscreen(cur->vis) != 0) err--;
	}

	return err;
}

int GGI_multi_putc(ggi_visual *vis, int x, int y, char c)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiPutc(cur->vis, x, y, c) != 0) err--;
	}

	return err;
}

int GGI_multi_puts(ggi_visual *vis, int x, int y, const char *str)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiPuts(cur->vis, x, y, str) != 0) err--;
	}

	return err;
}

int GGI_multi_drawhline(ggi_visual *vis, int x, int y, int w)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiDrawHLine(cur->vis, x, y, w) != 0) err--;
	}

	return err;
}

int GGI_multi_drawline(ggi_visual *vis, int x1, int y1, int x2, int y2)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiDrawLine(cur->vis, x1, y1, x2, y2) != 0) err--;
	}

	return err;
}

int GGI_multi_drawvline(ggi_visual *vis, int x, int y, int h)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiDrawVLine(cur->vis, x, y, h) != 0) err--;
	}

	return err;
}

int GGI_multi_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiCopyBox(cur->vis, x, y, w, h, nx, ny) != 0) err--;
	}

	return err;
}

int GGI_multi_setgamma(ggi_visual *vis, ggi_float r, ggi_float g, ggi_float b)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiSetGamma(cur->vis, r, g, b) != 0) err--;
	}

	return err;
} 

int GGI_multi_setgammamap(ggi_visual *vis, int start, int len, ggi_color *cmap)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiSetGammaMap(cur->vis, start, len, cmap) != 0) err--;
	}

	return err;
}

int GGI_multi_setpalvec(ggi_visual *vis, int start, int len, ggi_color *cmap)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiSetPalette(cur->vis, start, len, cmap) != 0) err--;
	}

	return err;
}

int GGI_multi_setorigin(ggi_visual *vis, int x, int y)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiSetOrigin(cur->vis, x, y) != 0) err--;
	}

	if (! err) {
		vis->origin_x=x;
		vis->origin_y=y;
	}
	
	return err;
}
