/**
 *
 * $Id: Draw.c,v 1.6 1998/09/24 15:37:37 pgw Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Id: Draw.c,v 1.6 1998/09/24 15:37:37 pgw Exp $";

#include <LTconfig.h>
#include <XmI/DebugUtil.h>
#include <Xm/DrawP.h>
#include <XmI/DrawI.h>
#include <XmI/ShadowI.h>

/* Used by List.c and IconG.c. */
void
_XmDrawHighlight(Display *display,
                 Drawable d,
                 GC gc,
                 Position x,
                 Position y,
                 Dimension width,
                 Dimension height,
                 Dimension highlight_thick,
                 int line_style)
{
   /* using _XmDrawHighlight in ShadowI.c */
   _XmDrawHighlight_1_2_(display, d, gc, x, y, width, height,
                              highlight_thick, line_style);
}

/* Shadow */
void
XmeClearBorder(Display *display,
	       Window win,
	       Position x,
	       Position y,
	       Dimension width,
	       Dimension height,
	       Dimension shadow_thick)
{
   /* using _XmClearBorder in ShadowI.c */
   _XmClearBorder_1_2_(display, win, x, y, width, height, shadow_thick);
}

/* Shadow */
void
XmeDrawShadows(Display *display,
	       Window win,
	       GC topShadowGC,
	       GC bottomShadowGC,
	       Position x, Position y,
	       Dimension width, Dimension height,
	       Dimension shadowThickness,
	       unsigned int shadowType)
{
   /* using _XmDrawShadows in ShadowI.c */
   _XmDrawShadows_1_2_(display, win, topShadowGC, bottomShadowGC,
                            x, y, width, height, shadowThickness, shadowType);
}

/* Shadow */
void
XmeDrawArrow(Display *display,
	     Window win,
	     GC bottomGC,
	     GC topGC,
	     GC fillGC,
	     Position x, Position y,
	     Dimension width, Dimension height,
	     Dimension shadowThickness,
	     unsigned char direction)
{
   /* using XmeDrawArrow in DrawI.c */
   XmeDrawArrow_2_0_(display, win, bottomGC, topGC, fillGC,
                     x, y, width, height, shadowThickness, direction);
}

/* Shadow */
void
XmeDrawDiamond(Display *display,
	       Window win,
	       GC bottomGC,
	       GC topGC,
	       GC selectGC,
	       Position x, Position y,
	       Dimension width, Dimension height,
	       Dimension shadowThickness,
	       Dimension fill)
{
   /* using _XmDrawDiamond in ShadowI.c */
   _XmDrawDiamond_1_2_(display, win, bottomGC, topGC, selectGC,
                            x, y, width, height, shadowThickness, fill);
}

/* Shadow */
void
XmeDrawSeparator(Display *display,
		 Drawable win,
		 GC top_gc,
		 GC bottom_gc,
		 GC separator_GC,
		 Position wx,
		 Position wy,
		 Dimension wwidth,
		 Dimension wheight,
		 Dimension shadowThickness,
		 Dimension margin,
		 unsigned char orientation,
		 unsigned char separator_type)
{
   /* using _XmDrawSeparator in ShadowI.c */
   _XmDrawSeparator_1_2_(display, win, top_gc, bottom_gc, separator_GC,
                              wx, wy, wwidth, wheight, shadowThickness, margin,
                              orientation, separator_type);
}

/* Shadow */
void
XmeDrawHighlight(Display *display,
		 Drawable d,
		 GC gc,
		 Position x,
		 Position y,
		 Dimension width,
		 Dimension height,
		 Dimension highlight_thick)
{
    _XmDrawHighlight(display, d, gc, x, y, width, height,
		     highlight_thick, LineSolid);
}

