/*
 * $Id: html.c,v 1.6 1998/09/26 14:04:28 ch Exp $
 *
 *
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998  Christian Hammers <ch@westend.com>
 *	
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <strings.h>
#include "libch.h"

struct {
	char	h[8];
	char	a;
}	ch_html_map[]	=    {{"&auml;",''}, 
		              {"&Auml;",''}, 
			      {"&ouml;",''}, 
			      {"&Ouml;",''},
	                      {"&uuml;",''},
			      {"&Uuml;",''},
			      {"&szlig;",''},
			      {"&quot;",'"'},
			      {"&lt;",'<'},
			      {"&gt;",'>'}};
int	ch_html_map_max	= sizeof(ch_html_map)/sizeof(ch_html_map[0]);


int ch_html_escape (char *out, const unsigned char *in, int maxout) {
	int	max=(int)out+maxout;
	int	i;

	while (*in) {
		/* chars that are unprintable in HTML */
		if (*in>=128) {
			if ((int)out>max-6) return 0; 
			sprintf(out,"&#%03u;",*in);
			out+=6; in++; continue;
		}
		/* the special chars */
		for (i=0; i<ch_html_map_max; i++) {
			if (*in == ch_html_map[i].a) {
				strcat(out,ch_html_map[i].h);
				out += strlen(ch_html_map[i].h);
				in++;
				continue;
			}
		}
		*out++ = *in++; *out='\0';
	}
	return 1;
}

int ch_html_unescape (char *out, const unsigned char *in, int maxout) {
	char 	*max=out+maxout;
	int	i;
	char	tmp[10];

	*out='\0';
	while (*in) {
	  if (out>=max) return 0;
	  if (*in=='&') {
		/* numerical escaped */
	    	if (*(in+1)=='#') { 
			if (*(in+2)=='x') {		
	  		    *out=*(in+3)>='A' ? *(in+3)-'A'+10 : *(in+3)-'0';
		  	    *out*=16;
		  	    *out+=*(in+4)>='A' ? *(in+4)-'A'+10 : *(in+4)-'0';
		  	    out++; in+=6;
		  	    continue;
			} else {	
			    in+=2; i=0; tmp[i]='\0';
			    while ( (*in>='0') && (*in<='9') && (i<=8)) {
				tmp[i++] = *in++;
			    }
			    tmp[i]='\0';
			    sscanf(tmp,"%d",&i);
			    sprintf(out,"%c",i);
			    out++; in++;
			    continue;
		  	}    
	 	}
		/* html escaped */
		for (i=0; i<ch_html_map_max; i++) {
			if (!strncmp(in,ch_html_map[i].h,strlen(ch_html_map[i].h))) {
				*out++ = ch_html_map[i].a;
				in+=strlen(ch_html_map[i].h); 
				continue;
			}
		}
	  }
	  /* default */
	  *out++=*in++; *out='\0';
	}  
	return 1;
}

