/*
 * $Id: time.c,v 1.4 1998/09/26 14:10:52 ch Exp $
 *
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Types: struct tm / time_t / date_string 
 *
 * Functions:
 *	tm2timet, tm2str
 * 	timet2tm, timet2str
 *	str2tm, str2timet
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

time_t ch_time_get() {
	return time(NULL);
}

int ch_time_tm2timet(struct tm *tm_in, time_t *timet_out) {
	*timet_out=mktime(tm_in);
	if (*timet_out==(time_t)(-1)) {
		return 1;
	}else{
		return 0;
	}
}

int ch_time_tm2str(struct tm *tm_in, char *str_out) {
	strcpy(str_out,asctime(tm_in));
	if (str_out==NULL) {
		return 1;
	}else{
		return 0;
	}
}

int ch_time_timet2tm(time_t timet_in, struct tm *tm_out) {
	memcpy(tm_out, localtime(&timet_in), sizeof(struct tm));
	return 0;
}

int ch_time_timet2str(time_t timet_in, char *str_out) {
	strcpy(str_out, ctime(&timet_in));
	if (str_out==NULL) {
		return 1;
	}else{
		return 0;
	}
}

int ch_time_str2tm(char *str_in, struct tm *tm_out) {
	/* formats: [0]2.[0]4.[19]95 / [19]980405 / [0]2.[0]4.2042 13:56 */
	char		tmp[18];
	char		*tmpp;
	time_t		tmpt;
	struct tm	tmptm;
	int		ok=0;

	memset(tm_out,0,sizeof(struct tm));
	memset(&tmptm,0,sizeof(struct tm));

	/* format: 980405 */
	if (strlen(str_in)==6) {
		strncpy(tmp, &str_in[0], 2);
		if (sscanf(tmp,"%d",&tmptm.tm_year)!=1) return 11;
		strncpy(tmp, &str_in[2], 2);
		if (sscanf(tmp,"%d",&tmptm.tm_mon)!=1) return 12;
		strncpy(tmp, &str_in[4], 2);
		if (sscanf(tmp,"%d",&tmptm.tm_mday)!=1) return 13;
		tmptm.tm_mon--;
		ok=1;
	}

	/* format: 19980405 */
	if (strlen(str_in)==8) {
		strncpy(tmp, &str_in[0], 4);
		if (sscanf(tmp,"%d",&tmptm.tm_year)!=1) return 21;
		strncpy(tmp, &str_in[2], 2);
		if (sscanf(tmp,"%d",&tmptm.tm_mon)!=1) return 22;
		strncpy(tmp, &str_in[4], 2);
		if (sscanf(tmp,"%d",&tmptm.tm_mday)!=1) return 23;
		tmptm.tm_mon--;
		ok=2;
	}

	/* format: 02.04.1998 */
	if (strlen(str_in)>=10) {
		strcpy(tmp,str_in);
		if ((tmpp=strtok(tmp,".")) == NULL) return 31;
		if (sscanf(tmpp,"%02d",&tmptm.tm_mday)!=1) return 32;
		if ((tmpp=strtok(NULL,".")) == NULL) return 33;
		if (sscanf(tmpp,"%02d",&tmptm.tm_mon)!=1) return 34;
		if ((tmpp=strtok(NULL,"\0")) == NULL) return 35;
		if (sscanf(tmpp,"%04d",&tmptm.tm_year)!=1) return 36;
		tmptm.tm_mon--;
		ok=3;
	}

	/* format: <above> but now the time */
	if (strlen(str_in)==16) {
		strcpy(tmp,str_in);
		if ((tmpp=strtok(tmp,".")) == NULL) return 41;
		if (sscanf(tmpp,"%02d",&tmptm.tm_mday)!=1) return 42;
		if ((tmpp=strtok(NULL,".")) == NULL) return 43;
		if (sscanf(tmpp,"%02d",&tmptm.tm_mon)!=1) return 44;
		if ((tmpp=strtok(NULL," ")) == NULL) return 45;
		if (sscanf(tmpp,"%04d",&tmptm.tm_year)!=1) return 46;
		if ((tmpp=strtok(NULL,":")) == NULL) return 47;
		if (sscanf(tmpp,"%02d",&tmptm.tm_hour)!=1) return 48;
		if ((tmpp=strtok(NULL,"\0")) == NULL) return 49;
		if (sscanf(tmpp,"%02d",&tmptm.tm_min)!=1) return 50;
		tmptm.tm_mon--;
		ok=4;
	}

	if (!ok) return 99;
	if ((tmpt=mktime(&tmptm))==(time_t)(-1)) return 61;
	memcpy(tm_out,localtime(&tmpt),sizeof(struct tm));

	return 0;
}

int ch_time_str2timet(char *str_in, time_t *timet_out) {
	struct tm	tmptm;

	if (ch_time_str2tm(str_in, &tmptm)!=0) return 1;
	if ((*timet_out=mktime(&tmptm))==(time_t)(-1)) return 2;
	return 0;
}

