/* Copyright (C) 1991, 1992, 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdlib.h>
#include <wchar.h>

/* Convert the `wchar_t' string in PWCS to a multibyte character string
   in S, writing no more than N characters.  Return the number of bytes
   written, or (size_t) -1 if an invalid `wchar_t' was found.

   Attention: this function should NEVER be intentionally used.
   The interface is completely stupid.  The state is shared between
   all conversion functions.  You should use instead the restartable
   version `wcsrtombs'.  */
size_t
wcstombs (char *s, const wchar_t *pwcs, size_t n)
{
  /*
   * The document file "libc.info-18" says at line 1109,
   *
   *  "- Function: size_t mbstowcs (wchar_t *WSTRING, const char *STRING,
   *      size_t SIZE)
   *      .......
   *   The conversion of characters from STRING begins in the initial
   *   shift state."
   *
   *  So, I think it must be given an initialized mbstate_t
   *  "initial_shift_state".
   */
  mbstate_t initial_shift_state = {0, (wint_t)0};

  /* Return how many we wrote (or maybe an error).  */
  return __wcsrtombs (s, &pwcs, n, &initial_shift_state);
}
