% Used by the array demo.

define num_rows (a)
{
   variable dims;
   (dims,,) = array_info (a);
   return dims[0];
}

define init_array (a)
{
   variable i, n;
   n = num_rows (a);
   for (i = 0; i < n; i++) a[i] = i;
}

define sum_elements (a)
{
   variable i, n, sum;
   
   n = num_rows (a);
   
   sum = 0.0;
   for (i = 0; i < n; i++) sum += a[i];
   return sum;
}

% The C array is called Vector. */
init_array (Vector);

% This will do a formatted print--- if you understand it, you understand 
% S-Lang
define printf ()
{
   () = fputs (Sprintf (_NARGS - 1), stdout);
}

printf ("Sum of elements Vector is: %f\n", sum_elements (Vector));

printf ("Sun of Vector_Read_Only is: %f\n", sum_elements (Vector_Read_Only));

printf ("The next line should fail:\n");
Vector_Read_Only[0] = 10;
quit ();


